/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.inventory.SwitchboardInventoryStackHandler;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ATileInventory
extends TileEntity
implements INamedContainerProvider {
    public static final String INVENTORY_TAG = "inv";
    protected final Integer INVENTORY_SIZE;
    protected LazyOptional<? extends ItemStackHandler> inventory;

    public ATileInventory(TileEntityType<?> type, Integer inventorySize) {
        super(type);
        this.INVENTORY_SIZE = inventorySize;
        this.inventory = inventorySize > 0 ? this.buildInventory() : LazyOptional.empty();
    }

    public LazyOptional<? extends ItemStackHandler> buildInventory() {
        return LazyOptional.of(() -> new SwitchboardInventoryStackHandler(this.INVENTORY_SIZE));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.inventory.ifPresent(inv -> compound.func_218657_a(INVENTORY_TAG, (INBT)inv.serializeNBT()));
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.ifPresent(inv -> inv.deserializeNBT(nbt.func_74775_l(INVENTORY_TAG)));
        if (!this.inventory.isPresent()) {
            this.inventory = LazyOptional.of(() -> new ItemStackHandler(this.INVENTORY_SIZE.intValue()));
        }
    }

    public ItemStackHandler getInventory() {
        return (ItemStackHandler)this.inventory.orElse(null);
    }

    public void setInventory(ItemStackHandler handler) {
        if (handler != null) {
            this.inventory = LazyOptional.of(() -> handler);
        }
    }
}

