/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TuningTableRecipe
implements IRecipe<IInventory> {
    public static IRecipeType<TuningTableRecipe> TYPE = IRecipeType.func_222147_a((String)"mimi:tuning");
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient instrument;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public TuningTableRecipe(ResourceLocation recipeId, Ingredient instrument, Ingredient addition, ItemStack result) {
        this.recipeId = recipeId;
        this.instrument = instrument;
        this.addition = addition;
        this.result = result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.instrument.test(inv.func_70301_a(0)) && this.addition.test(inv.func_70301_a(1));
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack itemstack = this.result.func_77946_l();
        CompoundNBT compoundnbt = inv.func_70301_a(0).func_77978_p();
        if (compoundnbt != null) {
            itemstack.func_77982_d(compoundnbt.func_74737_b());
        }
        return itemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public boolean isValidAdditionItem(ItemStack addition) {
        return this.addition.test(addition);
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Blocks.field_222429_lR);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public NonNullList<ItemStack> func_179532_b(IInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item.hasContainerItem()) {
                nonnulllist.set(i, (Object)item.getContainerItem());
                continue;
            }
            if (item.func_190916_E() <= 1) continue;
            ItemStack remaining = item.func_77946_l();
            remaining.func_190920_e(item.func_190916_E() - 1);
            nonnulllist.set(i, (Object)remaining);
        }
        return nonnulllist;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList result = NonNullList.func_191196_a();
        result.add(0, (Object)this.instrument);
        result.add(1, (Object)this.addition);
        return result;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TuningTableRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("mimi", "tuning"));
        }

        public TuningTableRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"instrument"));
            Ingredient ingredient1 = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new TuningTableRecipe(recipeId, ingredient, ingredient1, itemstack);
        }

        public TuningTableRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return new TuningTableRecipe(recipeId, ingredient, ingredient1, itemstack);
        }

        public void write(PacketBuffer buffer, TuningTableRecipe recipe) {
            recipe.instrument.func_199564_a(buffer);
            recipe.addition.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

