/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.entity.EntityNoteResponsiveTile;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacketHandler;
import io.github.tofodroid.mods.mimi.common.network.TransmitterNotePacket;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.common.tile.TileMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.tile.TileReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class TransmitterNotePacketHandler {
    public static void handlePacket(TransmitterNotePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
            ctx.get().enqueueWork(() -> TransmitterNotePacketHandler.handlePacketServer(message, ((NetworkEvent.Context)ctx.get()).getSender().func_233580_cy_(), ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q(), ((NetworkEvent.Context)ctx.get()).getSender().func_110124_au(), ((NetworkEvent.Context)ctx.get()).getSender()));
        }
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacketServer(TransmitterNotePacket message, BlockPos sourcePos, ServerWorld worldIn, UUID senderId, ServerPlayerEntity sender) {
        HashMap<UUID, List<MidiNotePacket>> notePackets = new HashMap<UUID, List<MidiNotePacket>>();
        for (ServerPlayerEntity player : TransmitterNotePacketHandler.getPotentialPlayers(message.transmitMode, sourcePos, worldIn, sender, TransmitterNotePacketHandler.getQueryBoxRange(message.velocity <= 0))) {
            ArrayList<MidiNotePacket> playerPackets = new ArrayList<MidiNotePacket>();
            TransmitterNotePacketHandler.handleHeldInstrumentRelayNote(player, senderId, Hand.MAIN_HAND, message, playerPackets);
            TransmitterNotePacketHandler.handleHeldInstrumentRelayNote(player, senderId, Hand.OFF_HAND, message, playerPackets);
            TransmitterNotePacketHandler.handleEntityInstrumentRelayNote(player, senderId, message, playerPackets);
            notePackets.put(player.func_110124_au(), playerPackets);
        }
        UUID mechUUID = new UUID(0L, 0L);
        notePackets.put(mechUUID, new ArrayList());
        for (TileMechanicalMaestro maestro : TransmitterNotePacketHandler.getPotentialMechMaestros(TransmitterNotePacketHandler.getPotentialEntities(message.transmitMode, sourcePos, worldIn, TransmitterNotePacketHandler.getQueryBoxRange(message.velocity <= 0)))) {
            if (!maestro.shouldHandleMessage(senderId, message.channel, message.note, message.transmitMode == TransmitterNotePacket.TransmitMode.PUBLIC).booleanValue()) continue;
            notePackets.get(mechUUID).add(new MidiNotePacket(message.note, ItemMidiSwitchboard.applyVolume(maestro.getSwitchboardStack(), message.velocity), maestro.getInstrumentId(), maestro.getMaestroUUID(), true, maestro.func_174877_v()));
        }
        TransmitterNotePacketHandler.sendPlayerOnPackets(notePackets, worldIn);
        if (message.velocity > 0) {
            for (TileReceiver receiver : TransmitterNotePacketHandler.getPotentialReceivers(TransmitterNotePacketHandler.getPotentialEntities(message.transmitMode, sourcePos, worldIn, TransmitterNotePacketHandler.getQueryBoxRange(false)))) {
                if (!receiver.shouldHandleMessage(senderId, message.channel, message.note, message.transmitMode == TransmitterNotePacket.TransmitMode.PUBLIC).booleanValue()) continue;
                ModBlocks.RECEIVER.powerTarget((IWorld)worldIn, receiver.func_195044_w(), 15, receiver.func_174877_v());
            }
        }
    }

    protected static void handleEntityInstrumentRelayNote(ServerPlayerEntity target, UUID sourceId, TransmitterNotePacket message, List<MidiNotePacket> packetList) {
        Byte instrumentId;
        TileInstrument instrumentEntity = BlockInstrument.getTileInstrumentForEntity((LivingEntity)target);
        if (instrumentEntity != null && (instrumentId = instrumentEntity.getInstrumentId()) != null && instrumentEntity.shouldHandleMessage(sourceId, message.channel, TransmitterNotePacket.TransmitMode.PUBLIC.equals((Object)message.transmitMode)).booleanValue()) {
            packetList.add(new MidiNotePacket(message.note, ItemMidiSwitchboard.applyVolume(instrumentEntity.getSwitchboardStack(), message.velocity), instrumentId, target.func_110124_au(), false, target.func_233580_cy_()));
        }
    }

    protected static void handleHeldInstrumentRelayNote(ServerPlayerEntity target, UUID sourceId, Hand handIn, TransmitterNotePacket message, List<MidiNotePacket> packetList) {
        ItemStack stack = ItemInstrument.getEntityHeldInstrumentStack((LivingEntity)target, handIn);
        Byte instrumentId = ItemInstrument.getInstrumentId(stack);
        if (instrumentId != null && stack != null && ItemInstrument.shouldHandleMessage(stack, sourceId, message.channel, TransmitterNotePacket.TransmitMode.PUBLIC.equals((Object)message.transmitMode)).booleanValue()) {
            packetList.add(new MidiNotePacket(message.note, ItemMidiSwitchboard.applyVolume(ItemInstrument.getSwitchboardStack(stack), message.velocity), instrumentId, target.func_110124_au(), false, target.func_233580_cy_()));
        }
    }

    protected static List<ServerPlayerEntity> getPotentialPlayers(TransmitterNotePacket.TransmitMode transmitMode, BlockPos sourcePos, ServerWorld worldIn, ServerPlayerEntity sender, Integer range) {
        List<Object> potentialPlayers = new ArrayList<ServerPlayerEntity>();
        if (transmitMode != TransmitterNotePacket.TransmitMode.SELF) {
            AxisAlignedBB queryBox = new AxisAlignedBB((double)(sourcePos.func_177958_n() - range), (double)(sourcePos.func_177956_o() - range), (double)(sourcePos.func_177952_p() - range), (double)(sourcePos.func_177958_n() + range), (double)(sourcePos.func_177956_o() + range), (double)(sourcePos.func_177952_p() + range));
            potentialPlayers = worldIn.func_175647_a(ServerPlayerEntity.class, queryBox, entity -> ItemInstrument.isEntityHoldingInstrument((LivingEntity)entity) != false || BlockInstrument.isEntitySittingAtInstrument((LivingEntity)entity) != false);
        } else if (sender != null) {
            potentialPlayers.add(sender);
        }
        return potentialPlayers;
    }

    protected static List<EntityNoteResponsiveTile> getPotentialEntities(TransmitterNotePacket.TransmitMode transmitMode, BlockPos sourcePos, ServerWorld worldIn, Integer range) {
        List<EntityNoteResponsiveTile> potentialEntites = new ArrayList<EntityNoteResponsiveTile>();
        if (transmitMode != TransmitterNotePacket.TransmitMode.SELF) {
            AxisAlignedBB queryBox = new AxisAlignedBB((double)(sourcePos.func_177958_n() - range), (double)(sourcePos.func_177956_o() - range), (double)(sourcePos.func_177952_p() - range), (double)(sourcePos.func_177958_n() + range), (double)(sourcePos.func_177956_o() + range), (double)(sourcePos.func_177952_p() + range));
            potentialEntites = worldIn.func_175647_a(EntityNoteResponsiveTile.class, queryBox, entity -> entity.getTile() != null);
        }
        return potentialEntites;
    }

    protected static List<TileMechanicalMaestro> getPotentialMechMaestros(List<EntityNoteResponsiveTile> entities) {
        return entities.stream().filter(e -> e.getTile() instanceof TileMechanicalMaestro).map(e -> (TileMechanicalMaestro)e.getTile()).collect(Collectors.toList());
    }

    protected static List<TileReceiver> getPotentialReceivers(List<EntityNoteResponsiveTile> entities) {
        return entities.stream().filter(e -> e.getTile() instanceof TileReceiver).map(e -> (TileReceiver)e.getTile()).collect(Collectors.toList());
    }

    protected static void sendPlayerOnPackets(HashMap<UUID, List<MidiNotePacket>> notePackets, ServerWorld worldIn) {
        if (!notePackets.isEmpty()) {
            for (UUID playerId : notePackets.keySet()) {
                List<MidiNotePacket> playerPackets = notePackets.get(playerId);
                if (playerPackets == null || playerPackets.isEmpty()) continue;
                MidiNotePacketHandler.handlePacketsServer(notePackets.get(playerId), worldIn, null);
            }
        }
    }

    protected static Integer getQueryBoxRange(Boolean off) {
        return off != false ? 32 : 16;
    }
}

