/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import net.minecraft.network.PacketBuffer;

public class TransmitterNotePacket {
    public static final Byte NO_CHANNEL = 127;
    public static final Byte ALL_NOTES_OFF = -128;
    public final Byte channel;
    public final Byte note;
    public final Byte velocity;
    public final TransmitMode transmitMode;

    public TransmitterNotePacket(Byte channel, Byte note, Byte velocity, TransmitMode transmitMode) {
        this.channel = channel;
        this.note = note;
        this.velocity = velocity;
        this.transmitMode = transmitMode;
    }

    public static TransmitterNotePacket decodePacket(PacketBuffer buf) {
        try {
            byte channel = buf.readByte();
            byte note = buf.readByte();
            byte velocity = buf.readByte();
            TransmitMode transmitMode = TransmitMode.values()[new Byte(buf.readByte()).intValue()];
            return new TransmitterNotePacket(channel, note, velocity, transmitMode);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("SpeakerNoteOnPacket did not contain enough bytes. Exception: " + e);
            return null;
        }
    }

    public static void encodePacket(TransmitterNotePacket pkt, PacketBuffer buf) {
        buf.writeByte((int)pkt.channel.byteValue());
        buf.writeByte((int)pkt.note.byteValue());
        buf.writeByte((int)pkt.velocity.byteValue());
        buf.writeByte((int)new Integer(pkt.transmitMode.ordinal()).byteValue());
    }

    public static enum TransmitMode {
        PUBLIC,
        LINKED,
        SELF;

    }
}

