/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.entity.EntityNoteResponsiveTile;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkManager;
import io.github.tofodroid.mods.mimi.common.tile.TileListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MidiNotePacketHandler {
    public static void handlePacket(MidiNotePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
            ctx.get().enqueueWork(() -> MidiNotePacketHandler.handlePacketsServer(Arrays.asList(message), ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q(), ((NetworkEvent.Context)ctx.get()).getSender()));
        } else {
            ctx.get().enqueueWork(() -> MidiNotePacketHandler.handlePacketClient(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacketsServer(List<MidiNotePacket> messages, ServerWorld worldIn, ServerPlayerEntity sender) {
        if (messages != null && !messages.isEmpty()) {
            for (MidiNotePacket packet : messages) {
                NetworkManager.NET_CHANNEL.send(MidiNotePacketHandler.getPacketTarget(packet.pos, worldIn, sender, MidiNotePacketHandler.getQueryBoxRange(packet.velocity <= 0)), (Object)packet);
            }
            List<EntityNoteResponsiveTile> entities = new ArrayList<EntityNoteResponsiveTile>();
            BlockPos lastPacketPos = null;
            for (MidiNotePacket packet : messages) {
                if (packet.velocity <= 0) continue;
                if (lastPacketPos != packet.pos) {
                    lastPacketPos = packet.pos;
                    entities = MidiNotePacketHandler.getPotentialEntities(worldIn, packet.pos, MidiNotePacketHandler.getQueryBoxRange(false).intValue());
                }
                MidiNotePacketHandler.getPotentialListeners(entities).forEach(listener -> {
                    if (listener.shouldAcceptNote(packet.note, packet.instrumentId).booleanValue()) {
                        ModBlocks.LISTENER.powerTarget((IWorld)worldIn, worldIn.func_180495_p(listener.func_174877_v()), 15, listener.func_174877_v());
                    }
                });
            }
        }
    }

    public static void handlePacketClient(MidiNotePacket message) {
        MIMIMod.proxy.getMidiSynth().handlePacket(message);
    }

    protected static List<EntityNoteResponsiveTile> getPotentialEntities(ServerWorld worldIn, BlockPos notePos, Integer range) {
        ArrayList<EntityNoteResponsiveTile> potentialEntites = new ArrayList();
        AxisAlignedBB queryBox = new AxisAlignedBB((double)(notePos.func_177958_n() - range), (double)(notePos.func_177956_o() - range), (double)(notePos.func_177952_p() - range), (double)(notePos.func_177958_n() + range), (double)(notePos.func_177956_o() + range), (double)(notePos.func_177952_p() + range));
        potentialEntites = worldIn.func_175647_a(EntityNoteResponsiveTile.class, queryBox, entity -> entity.getTile() != null);
        return potentialEntites;
    }

    protected static List<TileListener> getPotentialListeners(List<EntityNoteResponsiveTile> entities) {
        return entities.stream().filter(e -> e.getTile() instanceof TileListener).map(e -> (TileListener)e.getTile()).collect(Collectors.toList());
    }

    protected static PacketDistributor.PacketTarget getPacketTarget(BlockPos targetPos, ServerWorld worldIn, ServerPlayerEntity excludePlayer, Double range) {
        return PacketDistributor.NEAR.with(() -> {
            if (excludePlayer == null) {
                return new PacketDistributor.TargetPoint((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), range.doubleValue(), worldIn.func_234923_W_());
            }
            return new PacketDistributor.TargetPoint(excludePlayer, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), range.doubleValue(), worldIn.func_234923_W_());
        });
    }

    protected static Double getQueryBoxRange(Boolean off) {
        return off != false ? 128.0 : 64.0;
    }
}

