/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class MidiNotePacket {
    public static final Byte ALL_NOTES_OFF = -128;
    public final Byte note;
    public final Byte velocity;
    public final Byte instrumentId;
    public final UUID player;
    public final Boolean mechanical;
    public final BlockPos pos;

    public MidiNotePacket(Byte note, Byte velocity, Byte instrumentId, UUID player, Boolean mechanical, BlockPos pos) {
        this.note = note;
        this.velocity = velocity;
        this.instrumentId = instrumentId;
        this.player = player;
        this.mechanical = mechanical;
        this.pos = pos;
    }

    public static MidiNotePacket decodePacket(PacketBuffer buf) {
        try {
            byte note = buf.readByte();
            byte velocity = buf.readByte();
            byte instrumentId = buf.readByte();
            UUID player = buf.func_179253_g();
            Boolean mechanical = buf.readBoolean();
            BlockPos pos = buf.func_179259_c();
            return new MidiNotePacket(note, velocity, instrumentId, player, mechanical, pos);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MidiNoteOnPacket did not contain enough bytes. Exception: " + e);
            return null;
        }
    }

    public static void encodePacket(MidiNotePacket pkt, PacketBuffer buf) {
        buf.writeByte((int)pkt.note.byteValue());
        buf.writeByte((int)pkt.velocity.byteValue());
        buf.writeByte((int)pkt.instrumentId.byteValue());
        buf.func_179252_a(pkt.player);
        buf.writeBoolean(pkt.mechanical.booleanValue());
        buf.func_179255_a(pkt.pos);
    }
}

