/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.network.KeybindOpenInstrumentPacket;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeybindOpenInstrumentPacketHandler {
    public static void handlePacket(KeybindOpenInstrumentPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
            ctx.get().enqueueWork(() -> KeybindOpenInstrumentPacketHandler.handlePacketServer(message, ((NetworkEvent.Context)ctx.get()).getSender()));
        } else {
            MIMIMod.LOGGER.warn("Client recevied unexpected KeybindOpenInstrumentPacketHandler!");
        }
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacketServer(KeybindOpenInstrumentPacket message, ServerPlayerEntity sender) {
        if (message.handheld.booleanValue()) {
            Byte instrumentId = ItemInstrument.getEntityHeldInstrumentId((LivingEntity)sender, message.handIn);
            if (instrumentId != null) {
                ItemInstrument heldInstrument = (ItemInstrument)ItemInstrument.getEntityHeldInstrumentStack((LivingEntity)sender, message.handIn).func_77973_b();
                NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)heldInstrument.generateContainerProvider(message.handIn), buffer -> {
                    buffer.writeByte((int)instrumentId.byteValue());
                    buffer.writeBoolean(true);
                    buffer.writeBoolean(Hand.MAIN_HAND.equals((Object)message.handIn));
                });
            }
        } else {
            TileInstrument tile = BlockInstrument.getTileInstrumentForEntity((LivingEntity)sender);
            if (tile != null) {
                NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)tile, buffer -> {
                    buffer.writeByte((int)tile.getInstrumentId().byteValue());
                    buffer.writeBoolean(false);
                    buffer.func_179255_a(tile.func_174877_v());
                });
            }
        }
    }
}

