/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.mob.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.mob.villager.ItemsForItemsTrade;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.VillagesPools;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Triple;

public class ModVillagers {
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"mimi");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"mimi");
    public static final RegistryObject<PointOfInterestType> TUNINGTABLE = POI_TYPES.register("tuningtable", () -> new PointOfInterestType("instrumentalist", PointOfInterestType.func_221042_a((Block)ModBlocks.TUNINGTABLE), 1, 1));
    public static final RegistryObject<VillagerProfession> INSTRUMENTALIST = PROFESSIONS.register("instrumentalist", () -> new VillagerProfession("instrumentalist", (PointOfInterestType)TUNINGTABLE.get(), ImmutableSet.of((Object)Items.field_221664_at), ImmutableSet.of((Object)Blocks.field_196586_al), SoundEvents.field_219705_mM));
    public static final List<Triple<ResourceLocation, ResourceLocation, Integer>> JIGSAW_PIECES = Arrays.asList(ModVillagers.createJigsawPiece("village/plains/houses", "instrumentalist_house", 2), ModVillagers.createJigsawPiece("village/snowy/houses", "instrumentalist_house", 2), ModVillagers.createJigsawPiece("village/savanna/houses", "instrumentalist_house", 2), ModVillagers.createJigsawPiece("village/desert/houses", "instrumentalist_house", 2), ModVillagers.createJigsawPiece("village/taiga/houses", "instrumentalist_house", 2));

    public static void preInit(FMLJavaModLoadingContext fmlContext) {
        POI_TYPES.register(fmlContext.getModEventBus());
        PROFESSIONS.register(fmlContext.getModEventBus());
    }

    public static void init() {
        ModVillagers.injectPOITypes();
        ModVillagers.injectGiftTables();
        ModVillagers.injectTrades();
        ModVillagers.injectJigsawPatterns();
    }

    public static void injectPOITypes() {
        POI_TYPES.getEntries().forEach(entry -> {
            try {
                ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, entry.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void injectGiftTables() {
        PROFESSIONS.getEntries().forEach(entry -> GiveHeroGiftsTask.field_220403_a.put(entry.get(), new ResourceLocation(((VillagerProfession)entry.get()).getRegistryName().func_110624_b(), "gameplay/hero_of_the_village/" + ((VillagerProfession)entry.get()).getRegistryName().func_110623_a() + "_gift")));
    }

    public static void injectTrades() {
        VillagerTrades.field_221239_a.put(INSTRUMENTALIST.get(), new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForItemsTrade(Arrays.asList(Items.field_196158_dT, Items.field_196156_dS), 1, Arrays.asList(Items.field_151166_bC), 4, 16, 25), new ItemsForItemsTrade(Arrays.asList(Items.field_221664_at), 1, Arrays.asList(Items.field_151121_aF, Items.field_151137_ax), 8, 16, 20)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForItemsTrade(ModItems.INSTRUMENT_ITEMS, 1, Arrays.asList(Items.field_151166_bC), 4, 16, 25), new ItemsForItemsTrade(Arrays.asList(ModItems.SWITCHBOARD), 1, Arrays.asList(Items.field_151166_bC), 1, 32, 10)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new ItemsForItemsTrade(ModItems.BLOCK_INSTRUMENT_ITEMS, 1, Arrays.asList(Items.field_151166_bC), 4, 16, 25), new ItemsForItemsTrade(Arrays.asList(ModItems.MECHANICALMAESTRO, ModItems.CONDUCTOR, ModItems.RECEIVER), 1, Arrays.asList(Items.field_151166_bC), 8, 16, 30)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new ItemsForItemsTrade(Arrays.asList(ModItems.TRANSMITTER), 1, Arrays.asList(Items.field_151166_bC), 6, 16, 30), new ItemsForItemsTrade(Arrays.asList(ModItems.LISTENER), 1, Arrays.asList(Items.field_151166_bC), 4, 16, 25)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForItemsTrade(Arrays.asList(Items.field_234775_qK_, Items.field_196170_dZ, Items.field_196190_ed, Items.field_196187_ea, Items.field_196189_ec, Items.field_196188_eb, Items.field_196160_dU, Items.field_196162_dV, Items.field_196164_dW, Items.field_196166_dX, Items.field_196168_dY), 1, Arrays.asList(Items.field_151166_bC), 16, 1, 50), new ItemsForItemsTrade(ModItems.INSTRUMENT_ITEMS, 1, Arrays.asList(Items.field_151166_bC), 4, 16, 25)})));
    }

    public static void injectJigsawPatterns() {
        VillagesPools.func_244194_a();
        JIGSAW_PIECES.forEach(entry -> {
            JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a((ResourceLocation)entry.getLeft());
            ImmutableList shuffled = old != null ? old.func_214943_b(new Random()) : ImmutableList.of();
            List newPieces = shuffled.stream().map(p -> new Pair(p, (Object)1)).collect(Collectors.toList());
            newPieces.add(Pair.of(JigsawPiece.func_242849_a((String)((ResourceLocation)entry.getMiddle()).toString()).apply(JigsawPattern.PlacementBehaviour.RIGID), (Object)entry.getRight()));
            ResourceLocation name = old.func_214947_b();
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)((ResourceLocation)entry.getLeft()), (Object)new JigsawPattern((ResourceLocation)entry.getLeft(), name, newPieces));
        });
    }

    public static Triple<ResourceLocation, ResourceLocation, Integer> createJigsawPiece(String poolName, String entryName, Integer weight) {
        return Triple.of((Object)new ResourceLocation(poolName), (Object)new ResourceLocation("mimi", poolName + "/" + entryName), (Object)weight);
    }
}

