/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentBlock;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ItemTransmitter;
import io.github.tofodroid.mods.mimi.common.item.MIMIModItemGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="mimi")
public final class ModItems {
    public static List<ItemInstrument> INSTRUMENT_ITEMS = null;
    public static List<ItemInstrumentBlock> BLOCK_INSTRUMENT_ITEMS = null;
    public static final ItemTransmitter TRANSMITTER = null;
    public static final ItemMidiSwitchboard SWITCHBOARD = null;
    public static final BlockItem LISTENER = null;
    public static final BlockItem RECEIVER = null;
    public static final BlockItem MECHANICALMAESTRO = null;
    public static final BlockItem CONDUCTOR = null;
    public static final BlockItem TUNINGTABLE = null;
    public static MIMIModItemGroup ITEM_GROUP;

    public static List<ItemInstrument> buildInstruments() {
        ArrayList<ItemInstrument> list = new ArrayList<ItemInstrument>();
        for (InstrumentSpec instrument : InstrumentConfig.getItemInstruments()) {
            list.add(new ItemInstrument(instrument.registryName, instrument.instrumentId, instrument.isDyeable(), instrument.defaultColor()));
        }
        return list;
    }

    public static List<ItemInstrumentBlock> buildBlockInstruments() {
        ArrayList<ItemInstrumentBlock> list = new ArrayList<ItemInstrumentBlock>();
        for (InstrumentSpec instrument : InstrumentConfig.getBlockInstruments()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mimi", instrument.registryName));
            if (block instanceof BlockInstrument) {
                list.add((ItemInstrumentBlock)new ItemInstrumentBlock((BlockInstrument)block, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(1)).setRegistryName(instrument.registryName));
                continue;
            }
            MIMIMod.LOGGER.error("Failed to create ItemInstrumentBlock for Instrument: " + instrument.registryName + " - Corresponding Registry Block is not a BlockInstrument!");
        }
        return list;
    }

    @Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ITEM_GROUP = new MIMIModItemGroup();
            event.getRegistry().register((IForgeRegistryEntry)new ItemTransmitter());
            event.getRegistry().register((IForgeRegistryEntry)new ItemMidiSwitchboard());
            event.getRegistry().register(new BlockItem((Block)ModBlocks.LISTENER, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(64)).setRegistryName("listener"));
            event.getRegistry().register(new BlockItem((Block)ModBlocks.RECEIVER, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(64)).setRegistryName("receiver"));
            event.getRegistry().register(new BlockItem((Block)ModBlocks.MECHANICALMAESTRO, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(64)).setRegistryName("mechanicalmaestro"));
            event.getRegistry().register(new BlockItem((Block)ModBlocks.CONDUCTOR, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(64)).setRegistryName("conductor"));
            event.getRegistry().register(new BlockItem((Block)ModBlocks.TUNINGTABLE, new Item.Properties().func_200916_a((ItemGroup)ITEM_GROUP).func_200917_a(64)).setRegistryName("tuningtable"));
            INSTRUMENT_ITEMS = ModItems.buildInstruments();
            event.getRegistry().registerAll((IForgeRegistryEntry[])INSTRUMENT_ITEMS.toArray(new ItemInstrument[INSTRUMENT_ITEMS.size()]));
            BLOCK_INSTRUMENT_ITEMS = ModItems.buildBlockInstruments();
            event.getRegistry().registerAll((IForgeRegistryEntry[])BLOCK_INSTRUMENT_ITEMS.toArray(new ItemInstrumentBlock[BLOCK_INSTRUMENT_ITEMS.size()]));
        }
    }
}

