/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.midi.MidiChannelNumber;
import io.github.tofodroid.mods.mimi.common.network.SwitchboardStackUpdatePacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ItemMidiSwitchboard
extends Item {
    public static final String FILTER_NOTE_TAG = "filter_note";
    public static final String FILTER_OCT_TAG = "filter_oct";
    public static final String INVERT_NOTE_OCT_TAG = "invert_note_oct";
    public static final Byte FILTER_NOTE_OCT_ALL = -1;
    public static final String BROADCAST_NOTE_TAG = "broadcast_note";
    public static final String BROADCAST_PUBLIC_TAG = "broadcast_public";
    public static final String SOURCE_TAG = "source_uuid";
    public static final String SOURCE_NAME_TAG = "source_name";
    public static final String SYS_INPUT_TAG = "sys_input";
    public static final String ENABLED_CHANNELS_TAG = "enabled_channels";
    public static final String INSTRUMENT_TAG = "filter_instrument";
    public static final String INVERT_INSTRUMENT_TAG = "invert_instrument";
    public static final String VOLUME_TAG = "instrument_volume";
    public static final Byte INSTRUMENT_ALL = -1;
    public static final Byte MAX_INSTRUMENT_VOLUME = 5;
    public static final Byte DEFAULT_INSTRUMENT_VOLUME = 3;
    public static final Byte MIN_INSTRUMENT_VOLUME = 0;
    public static final UUID NONE_SOURCE_ID = new UUID(0L, 0L);
    public static final UUID PUBLIC_SOURCE_ID = new UUID(0L, 2L);
    public static final String ALL_CHANNELS_STRING = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16";
    private Map<Byte, String> INSTRUMENT_NAME_MAP = null;

    public ItemMidiSwitchboard() {
        super(new Item.Properties().func_200916_a((ItemGroup)ModItems.ITEM_GROUP).func_200917_a(1));
        this.setRegistryName("switchboard");
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!playerIn.func_130014_f_().func_201670_d()) {
            if (target instanceof PlayerEntity) {
                ItemMidiSwitchboard.setMidiSource(stack, target.func_110124_au(), target.func_200200_C_().getString());
                playerIn.func_184611_a(hand, stack);
                playerIn.func_146105_b((ITextComponent)new StringTextComponent("Set MIDI Source to: " + target.func_200200_C_().getString()), true);
                return ActionResultType.CONSUME;
            }
        } else if (target instanceof PlayerEntity) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (worldIn != null && worldIn.field_72995_K) {
            tooltip.add((ITextComponent)new StringTextComponent("----------------"));
            tooltip.add((ITextComponent)new StringTextComponent("Transmitter: " + ItemMidiSwitchboard.getMidiSourceName(stack)));
            if (ItemMidiSwitchboard.getSysInput(stack).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("System MIDI Device: Enabled"));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("System MIDI Device: Disabled"));
            }
            SortedArraySet<Byte> acceptedChannels = ItemMidiSwitchboard.getEnabledChannelsSet(stack);
            if (acceptedChannels != null && !acceptedChannels.isEmpty()) {
                if (acceptedChannels.size() == MidiChannelNumber.values().length) {
                    tooltip.add((ITextComponent)new StringTextComponent("Channels: All"));
                } else {
                    tooltip.add((ITextComponent)new StringTextComponent("Channels: " + acceptedChannels.stream().map(c -> new Integer(c.intValue() + 1).toString()).collect(Collectors.joining(", "))));
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("Channels: None"));
            }
            tooltip.add((ITextComponent)new StringTextComponent("Note Filter: " + (ItemMidiSwitchboard.getInvertNoteOct(stack) != false ? "All except " : "") + ItemMidiSwitchboard.getFilteredNotesAsString(stack)));
            tooltip.add((ITextComponent)new StringTextComponent("Instrument Filter: " + (ItemMidiSwitchboard.getInvertInstrument(stack) != false ? "All except " : "") + this.getInstrumentName(stack)));
            tooltip.add((ITextComponent)new StringTextComponent("Instrument Volume: " + ItemMidiSwitchboard.getInstrumentVolumePercent(stack)));
        }
    }

    public static void setMidiSource(ItemStack stack, UUID sourceId, String sourceName) {
        if (sourceId != null && sourceName != null) {
            stack.func_196082_o().func_186854_a(SOURCE_TAG, sourceId);
            stack.func_196082_o().func_74778_a(SOURCE_NAME_TAG, sourceName);
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(SOURCE_TAG);
            stack.func_77978_p().func_82580_o(SOURCE_NAME_TAG);
        }
    }

    public static UUID getMidiSource(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, SOURCE_TAG).booleanValue()) {
            return stack.func_77978_p().func_186857_a(SOURCE_TAG);
        }
        return null;
    }

    public static String getMidiSourceName(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, SOURCE_NAME_TAG).booleanValue()) {
            return stack.func_77978_p().func_74779_i(SOURCE_NAME_TAG);
        }
        if (ItemMidiSwitchboard.getMidiSource(stack) != null) {
            return "Player";
        }
        return "None";
    }

    public static void setEnabledChannelsString(ItemStack stack, String acceptedChannelsString) {
        if (acceptedChannelsString != null && !acceptedChannelsString.trim().isEmpty()) {
            stack.func_196082_o().func_74778_a(ENABLED_CHANNELS_TAG, acceptedChannelsString);
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(ENABLED_CHANNELS_TAG);
        }
    }

    public static String getEnabledChannelsString(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, ENABLED_CHANNELS_TAG).booleanValue()) {
            return stack.func_77978_p().func_74779_i(ENABLED_CHANNELS_TAG);
        }
        return null;
    }

    public static void toggleChannel(ItemStack switchStack, Byte channelId) {
        if (channelId != null && channelId < 16 && channelId >= 0) {
            SortedArraySet acceptedChannels = ItemMidiSwitchboard.getEnabledChannelsSet(switchStack);
            if (acceptedChannels == null) {
                acceptedChannels = SortedArraySet.func_226172_a_((int)16);
            }
            if (ItemMidiSwitchboard.isChannelEnabled(switchStack, channelId).booleanValue()) {
                acceptedChannels.remove((Object)channelId);
            } else {
                acceptedChannels.add((Object)channelId);
            }
            String acceptedChannelsString = acceptedChannels.stream().map(b -> new Integer(b + 1).toString()).collect(Collectors.joining(","));
            ItemMidiSwitchboard.setEnabledChannelsString(switchStack, acceptedChannelsString);
        }
    }

    public static void clearEnabledChannels(ItemStack switchStack) {
        ItemMidiSwitchboard.setEnabledChannelsString(switchStack, null);
    }

    public static void setEnableAllChannels(ItemStack switchStack) {
        ItemMidiSwitchboard.setEnabledChannelsString(switchStack, ALL_CHANNELS_STRING);
    }

    public static Boolean isChannelEnabled(ItemStack switchStack, Byte channelId) {
        return ItemMidiSwitchboard.getEnabledChannelsSet(switchStack).contains((Object)channelId);
    }

    public static SortedArraySet<Byte> getEnabledChannelsSet(ItemStack switchStack) {
        String acceptedChannelString = ItemMidiSwitchboard.getEnabledChannelsString(switchStack);
        if (acceptedChannelString != null && !acceptedChannelString.isEmpty()) {
            SortedArraySet result = SortedArraySet.func_226172_a_((int)16);
            result.addAll((Collection)Arrays.asList(acceptedChannelString.split(",", -1)).stream().map(b -> new Integer(Byte.valueOf(b) - 1).byteValue()).collect(Collectors.toSet()));
            return result;
        }
        return SortedArraySet.func_226172_a_((int)0);
    }

    public static void setFilterOct(ItemStack stack, Byte oct) {
        if (oct >= 0) {
            stack.func_196082_o().func_74774_a(FILTER_OCT_TAG, oct.byteValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(FILTER_OCT_TAG);
        }
    }

    public static void setFilterNote(ItemStack stack, Byte note) {
        if (note >= 0) {
            stack.func_196082_o().func_74774_a(FILTER_NOTE_TAG, note.byteValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(FILTER_NOTE_TAG);
        }
    }

    public static Byte getFilterOct(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, FILTER_OCT_TAG).booleanValue()) {
            return stack.func_77978_p().func_74771_c(FILTER_OCT_TAG);
        }
        return FILTER_NOTE_OCT_ALL;
    }

    public static Byte getFilterNote(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, FILTER_NOTE_TAG).booleanValue()) {
            return stack.func_77978_p().func_74771_c(FILTER_NOTE_TAG);
        }
        return FILTER_NOTE_OCT_ALL;
    }

    public static void setBroadcastNote(ItemStack stack, Byte note) {
        if (note >= 0) {
            stack.func_196082_o().func_74774_a(BROADCAST_NOTE_TAG, note.byteValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(BROADCAST_NOTE_TAG);
        }
    }

    public static Byte getBroadcastNote(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, BROADCAST_NOTE_TAG).booleanValue()) {
            return stack.func_77978_p().func_74771_c(BROADCAST_NOTE_TAG);
        }
        return (byte)0;
    }

    public static void setPublicBroadcast(ItemStack stack, Boolean pub) {
        if (pub.booleanValue()) {
            stack.func_196082_o().func_74757_a(BROADCAST_PUBLIC_TAG, pub.booleanValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(BROADCAST_PUBLIC_TAG);
        }
    }

    public static Boolean getPublicBroadcast(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, BROADCAST_PUBLIC_TAG).booleanValue()) {
            return stack.func_77978_p().func_74767_n(BROADCAST_PUBLIC_TAG);
        }
        return false;
    }

    public static void setInstrument(ItemStack stack, Byte instrumentId) {
        if (instrumentId >= 0) {
            stack.func_196082_o().func_74774_a(INSTRUMENT_TAG, instrumentId.byteValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(INSTRUMENT_TAG);
        }
    }

    public static Byte getInstrument(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, INSTRUMENT_TAG).booleanValue()) {
            return stack.func_77978_p().func_74771_c(INSTRUMENT_TAG);
        }
        return INSTRUMENT_ALL;
    }

    public static void setSysInput(ItemStack stack, Boolean sysInput) {
        if (sysInput.booleanValue()) {
            stack.func_196082_o().func_74757_a(SYS_INPUT_TAG, sysInput.booleanValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(SYS_INPUT_TAG);
        }
    }

    public static Boolean getSysInput(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, SYS_INPUT_TAG).booleanValue()) {
            return stack.func_77978_p().func_74767_n(SYS_INPUT_TAG);
        }
        return false;
    }

    public static void setInvertNoteOct(ItemStack stack, Boolean invert) {
        if (invert.booleanValue()) {
            stack.func_196082_o().func_74757_a(INVERT_NOTE_OCT_TAG, invert.booleanValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(INVERT_NOTE_OCT_TAG);
        }
    }

    public static Boolean getInvertNoteOct(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, INVERT_NOTE_OCT_TAG).booleanValue()) {
            return stack.func_77978_p().func_74767_n(INVERT_NOTE_OCT_TAG);
        }
        return false;
    }

    public static void setInvertInstrument(ItemStack stack, Boolean invert) {
        if (invert.booleanValue()) {
            stack.func_196082_o().func_74757_a(INVERT_INSTRUMENT_TAG, invert.booleanValue());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(INVERT_INSTRUMENT_TAG);
        }
    }

    public static Boolean getInvertInstrument(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, INVERT_INSTRUMENT_TAG).booleanValue()) {
            return stack.func_77978_p().func_74767_n(INVERT_INSTRUMENT_TAG);
        }
        return false;
    }

    public static void setInstrumentVolume(ItemStack stack, Byte volume) {
        if (volume > MAX_INSTRUMENT_VOLUME) {
            volume = MAX_INSTRUMENT_VOLUME;
        } else if (volume < MIN_INSTRUMENT_VOLUME) {
            volume = MIN_INSTRUMENT_VOLUME;
        }
        stack.func_196082_o().func_74774_a(VOLUME_TAG, volume.byteValue());
    }

    public static Byte getInstrumentVolume(ItemStack stack) {
        if (ItemMidiSwitchboard.stackTagContainsKey(stack, VOLUME_TAG).booleanValue()) {
            return stack.func_77978_p().func_74771_c(VOLUME_TAG);
        }
        return DEFAULT_INSTRUMENT_VOLUME;
    }

    public static String getInstrumentVolumePercent(ItemStack stack) {
        Integer value = new Integer(new Double(new Double(ItemMidiSwitchboard.getInstrumentVolume(stack).byteValue()) / new Double(MAX_INSTRUMENT_VOLUME.byteValue()) * 10.0).intValue());
        return value == 10 ? value.toString() : "0" + value.toString();
    }

    public static Byte applyVolume(ItemStack stack, Byte sourceVelocity) {
        Byte result = sourceVelocity;
        if (stack != null && stack.func_77973_b().equals((Object)ModItems.SWITCHBOARD)) {
            result = new Integer(new Double(new Double(ItemMidiSwitchboard.getInstrumentVolume(stack).byteValue()) / new Double(MAX_INSTRUMENT_VOLUME.byteValue()) * (double)sourceVelocity.byteValue()).intValue()).byteValue();
        }
        return result;
    }

    public String getInstrumentName(ItemStack stack) {
        return this.INSTRUMENT_NAME_MAP().get(new Integer(ItemMidiSwitchboard.getInstrument(stack).byteValue()).byteValue());
    }

    public static List<Byte> getFilterNotes(ItemStack stack) {
        ArrayList<Byte> result;
        block3: {
            Byte note;
            block4: {
                Byte oct;
                block2: {
                    result = new ArrayList<Byte>();
                    oct = ItemMidiSwitchboard.getFilterOct(stack);
                    note = ItemMidiSwitchboard.getFilterNote(stack);
                    if (oct == FILTER_NOTE_OCT_ALL || note == FILTER_NOTE_OCT_ALL || new Integer(oct * 12 + note) > 127) break block2;
                    result.add(new Integer(oct * 12 + note).byteValue());
                    break block3;
                }
                if (oct == FILTER_NOTE_OCT_ALL) break block4;
                for (int i = 0; i < 12; ++i) {
                    if (new Integer(oct * 12 + i) > 127) continue;
                    result.add(new Integer(oct * 12 + i).byteValue());
                }
                break block3;
            }
            if (note == FILTER_NOTE_OCT_ALL) break block3;
            for (int i = 0; i < 10; ++i) {
                if (new Integer(i * 12 + note) > 127) continue;
                result.add(new Integer(i * 12 + note).byteValue());
            }
        }
        return result;
    }

    public static String getFilteredNotesAsString(ItemStack stack) {
        Byte filterNoteLetter = ItemMidiSwitchboard.getFilterNote(stack);
        Byte filterNoteOctave = ItemMidiSwitchboard.getFilterOct(stack);
        String filterNoteString = ItemMidiSwitchboard.noteLetterFromNum(filterNoteLetter) + (filterNoteOctave != FILTER_NOTE_OCT_ALL ? filterNoteOctave : "*");
        return "**".equals(filterNoteString) ? "All" : filterNoteString;
    }

    public static String getBroadcastNoteAsString(ItemStack stack) {
        String result = "None";
        if (ItemMidiSwitchboard.getBroadcastNote(stack) != null) {
            Byte filterNoteLetter = new Integer(ItemMidiSwitchboard.getBroadcastNote(stack) % 12).byteValue();
            Byte filterNoteOctave = new Integer(ItemMidiSwitchboard.getBroadcastNote(stack) / 12).byteValue();
            result = ItemMidiSwitchboard.noteLetterFromNum(filterNoteLetter) + filterNoteOctave;
        }
        return result;
    }

    public static String noteLetterFromNum(Byte octaveNoteNum) {
        switch (octaveNoteNum) {
            case -1: {
                return "*";
            }
            case 0: {
                return "C";
            }
            case 1: {
                return "C#";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "D#";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "F#";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "G#";
            }
            case 9: {
                return "A";
            }
            case 10: {
                return "A#";
            }
            case 11: {
                return "B";
            }
        }
        return "";
    }

    public static Boolean isNoteFiltered(ItemStack stack, Byte note) {
        List<Byte> filteredNotes = ItemMidiSwitchboard.getFilterNotes(stack);
        return filteredNotes.isEmpty() ? !ItemMidiSwitchboard.getInvertNoteOct(stack).booleanValue() : (ItemMidiSwitchboard.getInvertNoteOct(stack).booleanValue() ? !filteredNotes.contains(note) : filteredNotes.contains(note));
    }

    public static Boolean isInstrumentFiltered(ItemStack stack, Byte instrument) {
        Byte instrumentId = ItemMidiSwitchboard.getInstrument(stack);
        return instrumentId.equals(INSTRUMENT_ALL) ? !ItemMidiSwitchboard.getInvertInstrument(stack).booleanValue() : (ItemMidiSwitchboard.getInvertInstrument(stack).booleanValue() ? instrumentId != instrument : instrumentId == instrument);
    }

    protected static Boolean stackTagContainsKey(ItemStack stack, String tag) {
        return stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(tag);
    }

    public static SwitchboardStackUpdatePacket getSyncPacket(ItemStack stack) {
        return new SwitchboardStackUpdatePacket(ItemMidiSwitchboard.getMidiSource(stack), ItemMidiSwitchboard.getMidiSourceName(stack), ItemMidiSwitchboard.getFilterOct(stack), ItemMidiSwitchboard.getFilterNote(stack), ItemMidiSwitchboard.getInvertNoteOct(stack), ItemMidiSwitchboard.getEnabledChannelsString(stack), ItemMidiSwitchboard.getInstrument(stack), ItemMidiSwitchboard.getInvertInstrument(stack), ItemMidiSwitchboard.getSysInput(stack), ItemMidiSwitchboard.getPublicBroadcast(stack), ItemMidiSwitchboard.getBroadcastNote(stack), ItemMidiSwitchboard.getInstrumentVolume(stack));
    }

    public Map<Byte, String> INSTRUMENT_NAME_MAP() {
        if (this.INSTRUMENT_NAME_MAP == null) {
            this.INSTRUMENT_NAME_MAP = this.loadInstrumentNames();
        }
        return this.INSTRUMENT_NAME_MAP;
    }

    protected Map<Byte, String> loadInstrumentNames() {
        HashMap<Byte, String> result = new HashMap<Byte, String>();
        result.put(new Integer(-1).byteValue(), "All");
        ModItems.INSTRUMENT_ITEMS.forEach(item -> result.put(item.getInstrumentId(), item.func_200296_o().getString()));
        ModItems.BLOCK_INSTRUMENT_ITEMS.forEach(item -> result.put(item.getInstrumentId(), item.func_179223_d().func_235333_g_().getString()));
        return result;
    }
}

