/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.container.ContainerInstrument;
import io.github.tofodroid.mods.mimi.common.item.IDyeableInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ItemInstrument
extends Item
implements IDyeableInstrumentItem {
    public static final String INVENTORY_TAG = "inventory";
    protected final Byte instrumentId;
    protected final Boolean dyeable;
    protected final Integer defaultColor;

    public ItemInstrument(String name, Byte instrumentId, Boolean dyeable, Integer defaultColor) {
        super(new Item.Properties().func_200916_a((ItemGroup)ModItems.ITEM_GROUP).func_200917_a(1));
        this.setRegistryName(name);
        this.instrumentId = instrumentId;
        this.dyeable = dyeable;
        this.defaultColor = defaultColor;
    }

    @Override
    public Boolean isDyeable() {
        return this.dyeable;
    }

    @Override
    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195999_j().func_225608_bj_() && ((IDyeableInstrumentItem)context.func_195996_i().func_77973_b()).func_200883_f_(context.func_195996_i()) && context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() instanceof CauldronBlock) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this.generateContainerProvider(handIn), buffer -> {
                buffer.writeByte((int)this.instrumentId.byteValue());
                buffer.writeBoolean(true);
                buffer.writeBoolean(Hand.MAIN_HAND.equals((Object)handIn));
            });
            return new ActionResult(ActionResultType.CONSUME, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public INamedContainerProvider generateContainerProvider(final Hand handIn) {
        return new InstrumentContainerProvider(){

            @Override
            public Container createMenu(int p1, PlayerInventory p2, PlayerEntity p3) {
                return new ContainerInstrument(p1, p2, ItemInstrument.this.instrumentId, handIn);
            }

            @Override
            public ITextComponent func_145748_c_() {
                return ItemInstrument.this.getMenuDisplayName();
            }
        };
    }

    public ITextComponent getMenuDisplayName() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public static Byte getInstrumentId(ItemStack stack) {
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemInstrument) {
            return ((ItemInstrument)stack.func_77973_b()).getInstrumentId();
        }
        return null;
    }

    public static String getInstrumentName(ItemStack stack) {
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemInstrument) {
            return stack.func_77973_b().func_200296_o().getString();
        }
        return null;
    }

    public static ItemStackHandler getInventoryHandler(ItemStack stack) {
        ItemStackHandler handler = new ItemStackHandler(1);
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(INVENTORY_TAG)) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l(INVENTORY_TAG));
        }
        return handler;
    }

    public static ItemStack getEntityHeldInstrumentStack(LivingEntity entity, Hand handIn) {
        ItemStack heldStack = entity.func_184586_b(handIn);
        if (heldStack != null && heldStack.func_77973_b() instanceof ItemInstrument) {
            return heldStack;
        }
        return null;
    }

    public static Boolean isEntityHoldingInstrument(LivingEntity entity) {
        return ItemInstrument.getEntityHeldInstrumentStack(entity, Hand.MAIN_HAND) != null || ItemInstrument.getEntityHeldInstrumentStack(entity, Hand.OFF_HAND) != null;
    }

    public static Byte getEntityHeldInstrumentId(LivingEntity entity, Hand handIn) {
        ItemStack instrumentStack = ItemInstrument.getEntityHeldInstrumentStack(entity, handIn);
        if (instrumentStack != null) {
            return ((ItemInstrument)instrumentStack.func_77973_b()).getInstrumentId();
        }
        return null;
    }

    public static ItemStack getSwitchboardStack(ItemStack stack) {
        ItemStackHandler handler = ItemInstrument.getInventoryHandler(stack);
        if (((Object)((Object)ModItems.SWITCHBOARD)).equals(handler.getStackInSlot(0).func_77973_b())) {
            return handler.getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public static Boolean shouldHandleMessage(ItemStack stack, UUID sender, Byte channel, Boolean publicTransmit) {
        ItemStack switchStack = ItemInstrument.getSwitchboardStack(stack);
        if (!switchStack.func_190926_b()) {
            return ItemMidiSwitchboard.isChannelEnabled(switchStack, channel) != false && (publicTransmit != false && ItemMidiSwitchboard.PUBLIC_SOURCE_ID.equals(ItemMidiSwitchboard.getMidiSource(switchStack)) || sender != null && sender.equals(ItemMidiSwitchboard.getMidiSource(switchStack)));
        }
        return false;
    }

    public static Boolean hasSwitchboard(ItemStack stack) {
        return !ItemInstrument.getSwitchboardStack(stack).func_190926_b();
    }

    protected class InstrumentContainerProvider
    implements INamedContainerProvider {
        protected InstrumentContainerProvider() {
        }

        public Container createMenu(int p1, PlayerInventory p2, PlayerEntity p3) {
            return null;
        }

        public ITextComponent func_145748_c_() {
            return null;
        }
    }
}

