/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.container;

import io.github.tofodroid.mods.mimi.common.container.ASwitchboardContainer;
import io.github.tofodroid.mods.mimi.common.container.ModContainers;
import io.github.tofodroid.mods.mimi.common.container.slot.SlotDisabled;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerInstrument
extends ASwitchboardContainer {
    private static final int SWITCHBOARD_SLOT_POS_X = 127;
    private static final int SWITCHBOARD_SLOT_POS_Y = 219;
    protected static final int INVENTORY_PLAYER_START_X = 156;
    protected static final int INVENTORY_PLAYER_START_Y = 182;
    private final Hand handIn;
    private final BlockPos tilePos;
    private final Boolean handheld;
    private final Byte instrumentId;

    public ContainerInstrument(int id, PlayerInventory playerInventory) {
        super(ModContainers.INSTRUMENT, id, playerInventory);
        this.handIn = null;
        this.tilePos = null;
        this.handheld = null;
        this.instrumentId = null;
    }

    public ContainerInstrument(int id, PlayerInventory playerInventory, PacketBuffer extraData) {
        super(ModContainers.INSTRUMENT, id, playerInventory);
        this.instrumentId = extraData.readByte();
        this.handheld = extraData.readBoolean();
        if (this.handheld.booleanValue()) {
            this.tilePos = null;
            this.handIn = extraData.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
            this.targetInventory = ItemInstrument.getInventoryHandler(playerInventory.field_70458_d.func_184586_b(this.handIn));
        } else {
            this.handIn = null;
            this.tilePos = extraData.func_179259_c();
            this.targetInventory = (ItemStackHandler)playerInventory.field_70458_d.field_70170_p.func_175625_s(this.tilePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
        }
        this.func_75146_a(this.buildSwitchboardSlot());
    }

    public ContainerInstrument(int id, PlayerInventory playerInventory, Byte instrumentId, Hand handIn) {
        super(ModContainers.INSTRUMENT, id, playerInventory);
        this.handheld = true;
        this.instrumentId = instrumentId;
        this.handIn = handIn;
        this.tilePos = null;
        this.targetInventory = ItemInstrument.getInventoryHandler(playerInventory.field_70458_d.func_184586_b(handIn));
        this.func_75146_a(this.buildSwitchboardSlot());
    }

    public ContainerInstrument(int id, PlayerInventory playerInventory, Byte instrumentId, BlockPos tilPos) {
        super(ModContainers.INSTRUMENT, id, playerInventory);
        this.handheld = false;
        this.instrumentId = instrumentId;
        this.tilePos = tilPos;
        this.handIn = null;
        this.targetInventory = (ItemStackHandler)playerInventory.field_70458_d.field_70170_p.func_175625_s(this.tilePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
        this.func_75146_a(this.buildSwitchboardSlot());
    }

    @Override
    protected Integer getPlayerInventoryX() {
        return 156;
    }

    @Override
    protected Integer getPlayerInventoryY() {
        return 182;
    }

    @Override
    protected Integer getSwitchboardSlotX() {
        return 127;
    }

    @Override
    protected Integer getSwitchboardSlotY() {
        return 219;
    }

    @Override
    protected Slot buildPlayerSlot(PlayerInventory playerInventory, int slot, int xPos, int yPos) {
        if (playerInventory.func_70301_a(slot).func_77973_b() instanceof ItemInstrument) {
            return new SlotDisabled((IInventory)playerInventory, slot, xPos, yPos);
        }
        return new Slot((IInventory)playerInventory, slot, xPos, yPos);
    }

    @Override
    public Boolean updateSelectedSwitchboard(ServerPlayerEntity player, UUID newSourceId, String newSourceName, Byte newFilterOct, Byte newFilterNote, Boolean newInvertNoteOct, String newChannelString, Byte newInstrumentId, Boolean newInvertInstrument, Boolean newSysInput, Boolean newPublicBroadcast, Byte newBroadcastNote, Byte newVolume) {
        if (super.updateSelectedSwitchboard(player, newSourceId, newSourceName, newFilterOct, newFilterNote, newInvertNoteOct, newChannelString, newInstrumentId, newInvertInstrument, newSysInput, newPublicBroadcast, newBroadcastNote, newVolume).booleanValue()) {
            this.saveToInventory((PlayerEntity)player);
            return true;
        }
        return false;
    }

    @Override
    public void func_75134_a(PlayerEntity player) {
        this.saveToInventory(player);
        super.func_75134_a(player);
    }

    public void saveToInventory(PlayerEntity player) {
        ItemStack instrumentStack;
        if (this.handheld.booleanValue() && this.handIn != null && (instrumentStack = player.func_184586_b(this.handIn)).func_77973_b() instanceof ItemInstrument) {
            CompoundNBT tag = instrumentStack.func_196082_o();
            tag.func_218657_a("inventory", (INBT)this.targetInventory.serializeNBT());
        }
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public Boolean isHandheld() {
        return this.handheld;
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    public Hand getHandIn() {
        return this.handIn;
    }
}

