/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.config.instrument;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;

public abstract class InstrumentConfig {
    private static List<InstrumentSpec> instrumentSpecs = null;

    public static List<InstrumentSpec> getItemInstruments() {
        return InstrumentConfig.getAllInstruments().stream().filter(s -> s.isBlock == false).collect(Collectors.toList());
    }

    public static List<InstrumentSpec> getItemInstruments(Boolean dyeable) {
        return InstrumentConfig.getAllInstruments().stream().filter(s -> s.isBlock == false && s.isDyeable() == dyeable).collect(Collectors.toList());
    }

    public static List<InstrumentSpec> getBlockInstruments() {
        return InstrumentConfig.getAllInstruments().stream().filter(s -> s.isBlock).collect(Collectors.toList());
    }

    public static List<InstrumentSpec> getBlockInstruments(Boolean dyeable) {
        return InstrumentConfig.getAllInstruments().stream().filter(s -> s.isBlock != false && s.isDyeable() == dyeable).collect(Collectors.toList());
    }

    public static List<InstrumentSpec> getAllInstruments() {
        return instrumentSpecs;
    }

    private static InputStreamReader getCustomInstrumentJsonStream(Path gameDir) throws IOException {
        File mimiFolder = new File(gameDir.toString(), "mimi");
        if (!mimiFolder.exists() && !mimiFolder.mkdirs()) {
            throw new IOException("Could not create MIMI config directory!");
        }
        File mimiJson = new File(gameDir.toString(), "mimi/custom.json");
        if (!mimiJson.exists()) {
            InputStream defaultData = InstrumentConfig.class.getClassLoader().getResourceAsStream("data/mimi/instruments/custom.json");
            Files.copy(defaultData, mimiJson.toPath(), StandardCopyOption.REPLACE_EXISTING);
            IOUtils.closeQuietly((InputStream)defaultData);
        }
        return new InputStreamReader(new FileInputStream(mimiJson));
    }

    public static void preInit() {
        instrumentSpecs = null;
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<InstrumentSpec>>(){}.getType();
        instrumentSpecs = (List)gson.fromJson((Reader)new InputStreamReader(InstrumentConfig.class.getClassLoader().getResourceAsStream("data/mimi/instruments/default.json")), listType);
        try {
            List customInstruments = (List)gson.fromJson((Reader)InstrumentConfig.getCustomInstrumentJsonStream(FMLPaths.CONFIGDIR.get()), listType);
            if (!customInstruments.isEmpty() && customInstruments != null) {
                for (int i = 0; i < customInstruments.size(); ++i) {
                    if (new Integer(instrumentSpecs.size() + i).byteValue() > 127) {
                        throw new IllegalStateException("Failed to load custom instrument specs! Instrument limit of 128 reached!");
                    }
                    ((InstrumentSpec)customInstruments.get((int)i)).instrumentId = new Integer(instrumentSpecs.size() + i).byteValue();
                }
                instrumentSpecs.addAll(customInstruments);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load custom instrument specs!", e);
        }
    }

    public static InstrumentSpec getBydId(byte id) {
        for (InstrumentSpec i : InstrumentConfig.getAllInstruments()) {
            if (!i.instrumentId.equals(id)) continue;
            return i;
        }
        return null;
    }
}

