/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.config;

import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public static final String INSTRUMENT_GUI_CATEGORY_NAME = "Instrument GUI";
    public static final String MIDI_PLAYER_CATEGORY_NAME = "MIDI Player";
    public static final String MIDI_INPUT_CATEGORY_NAME = "MIDI Input";
    public static final String MIDI_SYNTH_CATEGORY_NAME = "MIDI Synth";
    public ForgeConfigSpec.EnumValue<KEYBOARD_LAYOUTS> keyboardLayout;
    public ForgeConfigSpec.ConfigValue<String> playlistFolderPath;
    public ForgeConfigSpec.ConfigValue<String> selectedMidiDevice;
    public ForgeConfigSpec.BooleanValue enableMidiLogs;
    public ForgeConfigSpec.BooleanValue jitterCorrection;
    public ForgeConfigSpec.IntValue latency;
    public ForgeConfigSpec.ConfigValue<Integer> synthSampleRate;
    public ForgeConfigSpec.ConfigValue<Integer> synthBitRate;
    public ForgeConfigSpec.ConfigValue<String> soundfontPath;
    public ForgeConfigSpec.BooleanValue raytraceSound;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push(INSTRUMENT_GUI_CATEGORY_NAME);
        this.keyboardLayout = builder.comment("Instrument GUI keyboard layout for notes. MIMI uses its own layout by default but also supports the layout used by VirtualPiano.net.").translation("mimi.config.instrument.keyboard.layout").defineEnum("instrumentKeyboardLayout", (Enum)KEYBOARD_LAYOUTS.MIMI);
        builder.pop();
        builder.push(MIDI_PLAYER_CATEGORY_NAME);
        this.playlistFolderPath = builder.comment("Optional full path to a folder containing MIDI files to be used by the MIDI Player. See guide book for more information.").translation("mimi.config.midi.player.playlist.path").define("playlistFolderPath", (Object)"");
        builder.pop();
        builder.push(MIDI_INPUT_CATEGORY_NAME);
        this.selectedMidiDevice = builder.comment("What MIDI Input Device should be used (if available)? This can be set from the in-game MIDI Input Device Configuration menu. Changes require a game restart to take affect.").translation("mimi.config.midi.input.defaultdevice").define("defaultMidiInputDevice", (Object)"");
        this.enableMidiLogs = builder.comment("Should MIMI include detailed logs tracking MIDI note input and output?").translation("mimi.config.midi.synth.enablemidilogs").define("enableMidiLogs", false);
        builder.pop();
        builder.push(MIDI_SYNTH_CATEGORY_NAME);
        this.raytraceSound = builder.comment("Should MIDI notes that are played take into account any blocks between you and the source and muffle the sound accordingly? Note that enabling this may impact performance on lower-end systems.").translation("mimi.config.midi.synth.raytracesound").define("rayTraceSound", false);
        this.jitterCorrection = builder.comment("Should the built-in midi synthesizer enable Jitter Correction? When enabled note timing will be more accurate but latency will increase.").translation("mimi.config.midi.synth.jittercorrection").define("synthJitterCorrection", true);
        this.latency = builder.comment("What baseline latency should the built-in midi synthesizer use (ms)? Smaller values will decrease latency but may cause stutter when playing notes. Very small values may cause notes to fail to play at all.").translation("mimi.config.midi.synth.latency").defineInRange("synthBaselineLatency", 250, 10, 800);
        this.synthSampleRate = builder.comment(new String[]{"What sample rate should the built-in midi synthesizer use (hz)? Smaller values may decrease latency but will also decrease quality.", "Allowed values: [8000,11025,16000,22050,44100,48000,96000]"}).translation("mimi.config.midi.synth.samplerate").defineInList("synthSampleRate", (Object)44100, Arrays.asList(8000, 11025, 16000, 22050, 44100, 48000, 96000));
        this.synthBitRate = builder.comment(new String[]{"What bitrate should the built-in midi synthesizer use (bits)? Smaller values may decrease latency but will also decrease quality.", "Allowed values: [8,16,24,32]"}).translation("mimi.config.midi.synth.samplerate").defineInList("synthBitRate", (Object)16, Arrays.asList(8, 16, 24, 32));
        this.soundfontPath = builder.comment("Optional full path to an SF2 or DLS format SoundFont to be used by the MIDI Synthesizer. See project page for more information.").translation("mimi.config.midi.synth.soundfont.path").define("soundfontPath", (Object)"");
        builder.pop();
    }

    public static enum KEYBOARD_LAYOUTS {
        MIMI,
        VPiano;

    }
}

