/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.BlockConductor;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.BlockListener;
import io.github.tofodroid.mods.mimi.common.block.BlockMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.block.BlockReceiver;
import io.github.tofodroid.mods.mimi.common.block.BlockTuningTable;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.util.VoxelShapeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="mimi")
public class ModBlocks {
    public static final BlockListener LISTENER = null;
    public static final BlockReceiver RECEIVER = null;
    public static final BlockMechanicalMaestro MECHANICALMAESTRO = null;
    public static final BlockConductor CONDUCTOR = null;
    public static final BlockTuningTable TUNINGTABLE = null;
    public static List<BlockInstrument> INSTRUMENTS = null;

    public static List<BlockInstrument> buildInstruments() {
        ArrayList<BlockInstrument> result = new ArrayList<BlockInstrument>();
        for (InstrumentSpec instrument : InstrumentConfig.getBlockInstruments()) {
            result.add(new BlockInstrument(instrument.instrumentId, instrument.registryName, instrument.isDyeable(), instrument.defaultColor(), VoxelShapeUtils.loadFromStrings(instrument.collisionShapes)));
        }
        return result;
    }

    @Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{new BlockListener(), new BlockReceiver(), new BlockMechanicalMaestro(), new BlockConductor(), new BlockTuningTable()});
            INSTRUMENTS = ModBlocks.buildInstruments();
            event.getRegistry().registerAll((IForgeRegistryEntry[])INSTRUMENTS.toArray(new BlockInstrument[INSTRUMENTS.size()]));
        }
    }
}

