/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.AContainerBlock;
import io.github.tofodroid.mods.mimi.common.entity.EntitySeat;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.item.IDyeableInstrumentItem;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.VoxelShapeUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockInstrument
extends AContainerBlock<TileInstrument>
implements IWaterLoggable {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty DIRECTION = BlockStateProperties.field_208157_J;
    protected final Map<Direction, VoxelShape> SHAPES;
    protected final Byte instrumentId;
    protected final Boolean dyeable;
    protected final Integer defaultColor;

    public BlockInstrument(Byte instrumentId, String registryName, Boolean dyeable, Integer defaultColor, VoxelShape collisionShape) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        this.instrumentId = instrumentId;
        this.dyeable = dyeable;
        this.defaultColor = defaultColor;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes(collisionShape);
        this.setRegistryName(registryName);
    }

    protected Map<Direction, VoxelShape> generateShapes(VoxelShape shape) {
        return VoxelShapeUtils.generateFacingShape(shape);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileInstrument tileInstrument = (TileInstrument)((Object)this.getTileForBlock(worldIn, pos));
        if (tileInstrument != null && !worldIn.field_72995_K) {
            if (((Object)((Object)tileInstrument)).equals((Object)BlockInstrument.getTileInstrumentForEntity((LivingEntity)player))) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, worldIn, pos), buffer -> {
                    buffer.writeByte((int)this.instrumentId.byteValue());
                    buffer.writeBoolean(false);
                    buffer.func_179255_a(pos);
                });
            } else {
                return EntitySeat.create(worldIn, pos, this.getSeatOffset(state), player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public TileEntityType<TileInstrument> getTileType() {
        return ModTiles.INSTRUMENT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)DIRECTION, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DIRECTION});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.SHAPES.get(state.func_177229_b((Property)DIRECTION));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.SHAPES.get(state.func_177229_b((Property)DIRECTION));
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)DIRECTION, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)DIRECTION)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)DIRECTION)));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader reader) {
        TileInstrument tile = (TileInstrument)super.func_196283_a_(reader);
        return tile;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (IDyeableInstrumentItem.isDyeableInstrument(stack).booleanValue() && ((IDyeableInstrumentItem)stack.func_77973_b()).func_200883_f_(stack) && (tileentity = worldIn.func_175625_s(pos)) instanceof TileInstrument) {
            ((TileInstrument)tileentity).setColor(((IDyeableInstrumentItem)stack.func_77973_b()).func_200886_f(stack));
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity != null && tileentity instanceof TileInstrument && ((TileInstrument)tileentity).hasColor().booleanValue()) {
            for (ItemStack stack : drops) {
                if (!this.isDyeable().booleanValue() || !(stack.func_77973_b() instanceof IDyeableInstrumentItem)) continue;
                ((IDyeableInstrumentItem)stack.func_77973_b()).func_200885_a(stack, ((TileInstrument)tileentity).getColor());
            }
        }
        return drops;
    }

    public Boolean isDyeable() {
        return this.dyeable;
    }

    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    protected Vector3d getSeatOffset(BlockState state) {
        switch ((Direction)state.func_177229_b((Property)DIRECTION)) {
            case NORTH: {
                return new Vector3d(0.5, 0.0, 0.05);
            }
            case SOUTH: {
                return new Vector3d(0.5, 0.0, 0.95);
            }
            case EAST: {
                return new Vector3d(0.95, 0.0, 0.5);
            }
            case WEST: {
                return new Vector3d(0.05, 0.0, 0.5);
            }
        }
        return new Vector3d(0.5, 0.0, 0.05);
    }

    public static Boolean isEntitySittingAtInstrument(LivingEntity entity) {
        return entity.func_184218_aH() && ModEntities.SEAT.equals((Object)entity.func_184187_bx().func_200600_R());
    }

    public static EntitySeat getSeatForEntity(LivingEntity entity) {
        if (BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue()) {
            return (EntitySeat)entity.func_184187_bx();
        }
        return null;
    }

    public static TileInstrument getTileInstrumentForEntity(LivingEntity entity) {
        BlockPos pos;
        if (entity.func_70089_S() && BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue() && (pos = BlockInstrument.getSeatForEntity(entity).getSource()) != null && !World.func_189509_E((BlockPos)pos)) {
            TileEntity sourceEntity = entity.func_130014_f_().func_175625_s(BlockInstrument.getSeatForEntity(entity).getSource());
            return sourceEntity != null && sourceEntity instanceof TileInstrument ? (TileInstrument)sourceEntity : null;
        }
        return null;
    }
}

