/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.tile.ATileInventory;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public abstract class AContainerBlock<T extends ATileInventory>
extends ContainerBlock {
    protected AContainerBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ATileInventory) {
                this.dropInventoryItems(worldIn, pos, (IItemHandler)((ATileInventory)tileentity).getInventory());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        T tile;
        if (!worldIn.field_72995_K && (tile = this.getTileForBlock(worldIn, pos)) != null) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)this.func_220052_b(state, worldIn, pos), packetBuffer -> this.writeGuiPacketBuffer(state, worldIn, pos, player, hand, (PacketBuffer)packetBuffer));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return this.getTileType().func_200968_a();
    }

    public abstract TileEntityType<T> getTileType();

    public TileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return this.func_196283_a_(reader);
    }

    public void writeGuiPacketBuffer(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, PacketBuffer buffer) {
        buffer.func_179255_a(pos);
    }

    public T getTileForBlock(World worldIn, BlockPos pos) {
        TileEntity entity = worldIn.func_175625_s(pos);
        return (T)((Object)(entity != null && entity instanceof ATileInventory ? (ATileInventory)entity : null));
    }

    public void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }
}

