/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.sun.media.sound.SoftSynthesizer;
import io.github.tofodroid.mods.mimi.client.midi.MidiChannelDef;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ModConfigs;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.container.ContainerInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.midi.AMidiSynthManager;
import io.github.tofodroid.mods.mimi.common.midi.MidiChannelNumber;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.util.DebugUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class MidiSynthManager
extends AMidiSynthManager {
    private static final Integer MIDI_TICK_FREQUENCY = 1;
    private static final Double BLOCK_MIDI_REDUCTION = 0.5;
    private ImmutableList<MidiChannelDef> midiChannelSet;
    private BiMap<MidiChannelNumber, String> channelAssignmentMap;
    protected Soundbank soundbank = null;
    protected Synthesizer midiSynth;
    protected Receiver midiReceiver;
    protected Integer midiTickCounter = 0;

    public MidiSynthManager() {
        this.init();
    }

    @Override
    public void init() {
        this.soundbank = this.openSoundbank((String)ModConfigs.CLIENT.soundfontPath.get());
        this.midiSynth = this.openNewSynth(this.soundbank);
        this.midiReceiver = this.openNewReceiver(this.midiSynth);
        this.channelAssignmentMap = HashBiMap.create();
        if (this.midiSynth != null && this.midiReceiver != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MidiChannelNumber num : MidiChannelNumber.values()) {
                builder.add((Object)new MidiChannelDef(num.ordinal(), this.midiSynth.getChannels()[num.ordinal()]));
            }
            this.midiChannelSet = builder.build();
        } else {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.midiReceiver != null) {
            this.midiReceiver.close();
            this.midiReceiver = null;
        }
        if (this.midiSynth != null && this.midiSynth.isOpen()) {
            this.midiSynth.close();
            this.midiSynth = null;
        }
        this.soundbank = null;
        this.midiChannelSet = ImmutableList.of();
        this.channelAssignmentMap = HashBiMap.create();
    }

    @Override
    public void handlePacket(MidiNotePacket message) {
        if (message.velocity > 0) {
            this.noteOn(message);
        } else {
            this.noteOff(message);
        }
    }

    @Override
    public Boolean shouldShowOnGUI(UUID messagePlayer, Byte channel, Byte instrument) {
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        if (messagePlayer.equals(thisPlayer.func_110124_au()) && thisPlayer.field_71070_bA instanceof ContainerInstrument) {
            UUID midiSource;
            ItemStack switchStack = ((ContainerInstrument)thisPlayer.field_71070_bA).getSelectedSwitchboard();
            Byte guiInstrument = ((ContainerInstrument)thisPlayer.field_71070_bA).getInstrumentId();
            if (instrument == guiInstrument && ((Object)((Object)ModItems.SWITCHBOARD)).equals(switchStack.func_77973_b()) && (messagePlayer.equals(midiSource = ItemMidiSwitchboard.getMidiSource(switchStack)) || ItemMidiSwitchboard.PUBLIC_SOURCE_ID.equals(midiSource)) && ItemMidiSwitchboard.isChannelEnabled(switchStack, channel).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void allNotesOff() {
        if (this.midiSynth != null && this.midiReceiver != null) {
            for (MidiChannel channel : this.midiSynth.getChannels()) {
                channel.allNotesOff();
            }
        }
    }

    @Override
    public void allNotesOff(MidiChannelNumber num) {
        if (this.midiSynth != null && this.midiReceiver != null && num != null) {
            ((MidiChannelDef)this.midiChannelSet.get(num.ordinal())).noteOff(MidiNotePacket.ALL_NOTES_OFF);
        }
    }

    @Override
    @SubscribeEvent
    public void handleTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.CLIENT || !event.player.func_175144_cb()) {
            return;
        }
        Integer n = this.midiTickCounter;
        Integer n2 = this.midiTickCounter = Integer.valueOf(this.midiTickCounter + 1);
        if (this.midiTickCounter >= MIDI_TICK_FREQUENCY) {
            ArrayList toUnassign = new ArrayList();
            this.channelAssignmentMap.entrySet().forEach(entry -> {
                if (Boolean.FALSE.equals(((MidiChannelDef)this.midiChannelSet.get(((MidiChannelNumber)((Object)((Object)entry.getKey()))).ordinal())).tick(event.player))) {
                    toUnassign.add(entry.getKey());
                }
            });
            toUnassign.forEach(channel -> {
                ((MidiChannelDef)this.midiChannelSet.get(channel.ordinal())).reset();
                this.channelAssignmentMap.remove((Object)channel);
            });
            this.midiTickCounter = 0;
        }
    }

    @Override
    @SubscribeEvent
    public void handleSelfLogOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_175144_cb()) {
            this.allNotesOff();
        }
    }

    @Override
    @SubscribeEvent
    public void handleOtherLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().func_175144_cb()) {
            List<MidiChannelNumber> channelsToStop = this.getAllChannelsForPlayer(event.getPlayer().func_110124_au());
            for (MidiChannelNumber num : channelsToStop) {
                this.allNotesOff(num);
            }
        }
    }

    protected List<MidiChannelNumber> getAllChannelsForPlayer(UUID playerId) {
        ArrayList<MidiChannelNumber> result = new ArrayList<MidiChannelNumber>();
        for (String name : this.channelAssignmentMap.values()) {
            if (!name.contains(playerId.toString() + "-")) continue;
            result.add((MidiChannelNumber)((Object)this.channelAssignmentMap.inverse().get((Object)name)));
        }
        return result;
    }

    protected MidiChannelNumber getChannelForPlayer(UUID playerId, Boolean mechanical, Byte instrumentId, Boolean getNew) {
        if (playerId == null) {
            return null;
        }
        String channelIdentifier = this.getChannelIdentifier(playerId, instrumentId);
        MidiChannelNumber assignedChannelNum = (MidiChannelNumber)((Object)this.channelAssignmentMap.inverse().get((Object)channelIdentifier));
        if (assignedChannelNum != null) {
            return assignedChannelNum;
        }
        if (getNew.booleanValue()) {
            for (MidiChannelNumber num : MidiChannelNumber.values()) {
                if (this.channelAssignmentMap.get((Object)num) != null || num == MidiChannelNumber.NINE) continue;
                this.channelAssignmentMap.put((Object)num, (Object)channelIdentifier);
                ((MidiChannelDef)this.midiChannelSet.get(num.ordinal())).assign(playerId, mechanical, InstrumentConfig.getBydId(instrumentId));
                return num;
            }
        }
        return null;
    }

    protected String getChannelIdentifier(UUID playerId, Byte instrumentId) {
        return playerId.toString() + "-" + instrumentId.toString();
    }

    protected final void noteOn(MidiNotePacket message) {
        InstrumentSpec instrument = InstrumentConfig.getBydId(message.instrumentId);
        if (this.midiSynth == null || this.midiReceiver == null || instrument == null || message.velocity <= 0) {
            return;
        }
        MidiChannelNumber channelNumber = this.getChannelForPlayer(message.player, message.mechanical, message.instrumentId, true);
        MidiChannelDef channelDef = channelNumber != null ? (MidiChannelDef)this.midiChannelSet.get(channelNumber.ordinal()) : null;
        Double modifiedVelocity = new Double(message.velocity.byteValue());
        if (((Boolean)ModConfigs.CLIENT.raytraceSound.get()).booleanValue()) {
            Vector3d messageVec = new Vector3d((double)message.pos.func_177958_n() + 0.5, (double)message.pos.func_177956_o() + 0.5, (double)message.pos.func_177952_p() + 0.5);
            Vector3d playerVec = new Vector3d(Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), Minecraft.func_71410_x().field_71439_g.func_226280_cw_(), Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
            Vector3d rayVec = Minecraft.func_71410_x().field_71441_e.func_217299_a(new RayTraceContext(playerVec, messageVec, RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, null)).func_216347_e();
            if (messageVec.func_72438_d(playerVec) - rayVec.func_72438_d(playerVec) >= 1.0) {
                modifiedVelocity = modifiedVelocity * BLOCK_MIDI_REDUCTION;
                MIMIMod.LOGGER.info("Muffling!");
            }
        }
        if (modifiedVelocity.intValue() > 0 && channelDef != null) {
            channelDef.noteOn(instrument, message.note, new Integer(modifiedVelocity.intValue()).byteValue(), message.pos);
        }
    }

    protected final void noteOff(MidiNotePacket message) {
        MidiChannelDef channelDef;
        if (this.midiSynth == null || this.midiReceiver == null) {
            return;
        }
        MidiChannelNumber channelNumber = this.getChannelForPlayer(message.player, message.mechanical, message.instrumentId, false);
        MidiChannelDef midiChannelDef = channelDef = channelNumber != null ? (MidiChannelDef)this.midiChannelSet.get(channelNumber.ordinal()) : null;
        if (channelDef != null) {
            channelDef.noteOff(message.note);
        }
    }

    protected Synthesizer openNewSynth(Soundbank sounds) {
        try {
            Synthesizer midiSynth = MidiSystem.getSynthesizer();
            if (midiSynth.getMaxReceivers() != 0) {
                midiSynth.open();
                midiSynth.close();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("jitter correction", ModConfigs.CLIENT.jitterCorrection.get());
                params.put("latency", (Integer)ModConfigs.CLIENT.latency.get() * 1000);
                params.put("format", new AudioFormat(((Integer)ModConfigs.CLIENT.synthSampleRate.get()).intValue(), (Integer)ModConfigs.CLIENT.synthBitRate.get(), 2, true, false));
                DebugUtils.logSynthInfo(midiSynth, params);
                if (midiSynth instanceof SoftSynthesizer) {
                    ((SoftSynthesizer)midiSynth).open(null, params);
                } else {
                    MIMIMod.LOGGER.warn("Synthesizer is not Gervill. Ignoring synth settings.");
                    midiSynth.open();
                }
                midiSynth.open();
                if (sounds != null) {
                    if (midiSynth.isSoundbankSupported(sounds)) {
                        midiSynth.loadAllInstruments(sounds);
                    } else {
                        MIMIMod.LOGGER.error("Synthesizer could not load Soundbank. Falling back to default.");
                    }
                }
                return midiSynth;
            }
            throw new MidiUnavailableException("Midi Synth '" + midiSynth.getDeviceInfo().getName() + "' cannot support any receivers.");
        }
        catch (MidiUnavailableException e) {
            MIMIMod.LOGGER.error((Object)e);
            return null;
        }
    }

    protected Receiver openNewReceiver(Synthesizer synth) {
        if (synth != null) {
            try {
                return synth.getReceiver();
            }
            catch (MidiUnavailableException e) {
                MIMIMod.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    protected Soundbank openSoundbank(String resourcePath) {
        if (resourcePath != null && !resourcePath.trim().isEmpty()) {
            try {
                return MidiSystem.getSoundbank(new BufferedInputStream(new FileInputStream(new File(resourcePath.trim()))));
            }
            catch (IOException | NullPointerException | InvalidMidiDataException e) {
                MIMIMod.LOGGER.error("Failed to load SoundFont. Error: ", (Throwable)e);
            }
        }
        return null;
    }
}

