/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import com.sun.media.sound.MidiUtils;
import io.github.tofodroid.mods.mimi.client.midi.MidiFileInfo;
import io.github.tofodroid.mods.mimi.client.midi.MidiInputSourceManager;
import io.github.tofodroid.mods.mimi.client.midi.MidiSequenceInputReceiver;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ModConfigs;
import io.github.tofodroid.mods.mimi.common.network.TransmitterNotePacket;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;

public class MidiPlaylistManager
extends MidiInputSourceManager {
    private String playlistFolderPath;
    private List<MidiFileInfo> songList;
    private List<MidiFileInfo> originalList;
    private Long pausedTickPosition;
    private Long pausedMicrosecond;
    private Integer lastTempoBPM;
    private Integer selectedSongIndex;
    private LoopMode currentLoopMode = LoopMode.NONE;
    private TransmitterNotePacket.TransmitMode currentTransmitMode = TransmitterNotePacket.TransmitMode.PUBLIC;
    private Boolean shuffled = false;
    private Sequencer activeSequencer;
    private MidiSequenceInputReceiver activeReceiver;

    public MidiPlaylistManager() {
        this.createSequencer();
        this.loadFromFolder((String)ModConfigs.CLIENT.playlistFolderPath.get());
    }

    protected void resetPlaylist() {
        this.stop();
        this.playlistFolderPath = "";
        this.songList = new ArrayList<MidiFileInfo>();
        this.pausedTickPosition = null;
        this.pausedMicrosecond = null;
        this.lastTempoBPM = 120;
        this.selectedSongIndex = null;
        this.shuffled = false;
    }

    protected Boolean createSequencer() {
        try {
            this.activeSequencer = MidiSystem.getSequencer(false);
            this.activeSequencer.open();
            this.activeSequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage meta) {
                    if (MidiUtils.isMetaEndOfTrack(meta) && !MidiPlaylistManager.this.activeSequencer.isRunning()) {
                        switch (MidiPlaylistManager.this.currentLoopMode) {
                            case ALL: {
                                MidiPlaylistManager.this.stop();
                                MidiPlaylistManager.this.shiftSong(true);
                                MidiPlaylistManager.this.playFromBeginning();
                                break;
                            }
                            case SINGLE: {
                                MidiPlaylistManager.this.stop();
                                MidiPlaylistManager.this.playFromBeginning();
                                break;
                            }
                            default: {
                                MidiPlaylistManager.this.stop();
                                break;
                            }
                        }
                    } else if (MidiUtils.isMetaTempo(meta) | (meta.getType() == 81 && meta.getData().length == 3)) {
                        byte[] data = meta.getData();
                        int mspq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                        MidiPlaylistManager.this.lastTempoBPM = Math.round(6.0E7f / (float)mspq);
                        MidiPlaylistManager.this.activeSequencer.setTempoInBPM(MidiPlaylistManager.this.lastTempoBPM.intValue());
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            this.activeSequencer = null;
            this.activeReceiver = null;
            MIMIMod.LOGGER.error("Failed to create MIDI Sequencer: ", (Throwable)e);
            return false;
        }
    }

    protected Boolean loadSelectedSong() {
        if (this.isOpen().booleanValue() && this.isSongSelected().booleanValue()) {
            try {
                Path activePath = Paths.get(this.playlistFolderPath, this.songList.get((int)this.selectedSongIndex.intValue()).fileName);
                this.activeSequencer.setSequence(MidiSystem.getSequence(activePath.toFile()));
                this.lastTempoBPM = this.songList.get((int)this.selectedSongIndex.intValue()).tempo;
                return true;
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to open MIDI file " + Paths.get(this.playlistFolderPath, this.songList.get((int)this.selectedSongIndex.intValue()).fileName).toString(), (Throwable)e);
            }
        }
        return false;
    }

    public Boolean isOpen() {
        return this.activeSequencer != null && this.activeSequencer.isOpen();
    }

    public Boolean isSongSelected() {
        return this.selectedSongIndex != null;
    }

    public Boolean isSongLoaded() {
        return this.isOpen() != false && this.isSongSelected() != false && this.activeSequencer.getSequence() != null;
    }

    public Integer getSongLengthSeconds() {
        return this.isSongLoaded() != false ? Integer.valueOf(new Long(this.activeSequencer.getSequence().getMicrosecondLength() / 1000000L).intValue()) : null;
    }

    public Integer getCurrentSongPosSeconds() {
        Long micoPos;
        if (this.isPlaying().booleanValue()) {
            micoPos = this.activeSequencer.getMicrosecondPosition();
        } else if (this.pausedMicrosecond != null) {
            micoPos = this.pausedMicrosecond;
        } else if (this.isSongLoaded().booleanValue()) {
            micoPos = 0L;
        } else {
            return null;
        }
        return new Long(micoPos / 1000000L).intValue();
    }

    public MidiFileInfo getSelectedSongInfo() {
        return this.isSongSelected() != false ? this.songList.get(this.selectedSongIndex) : null;
    }

    public Integer getSelectedSongIndex() {
        return this.selectedSongIndex;
    }

    public String getPlaylistFolderPath() {
        return this.playlistFolderPath;
    }

    public List<MidiFileInfo> getLoadedPlaylist() {
        return this.songList;
    }

    public Boolean loadFromFolder(String folderPath) {
        this.resetPlaylist();
        if (folderPath != null && !folderPath.trim().isEmpty() && Files.isDirectory(Paths.get(folderPath.trim(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            this.playlistFolderPath = folderPath.trim();
            for (File file : new File(this.playlistFolderPath).listFiles()) {
                MidiFileInfo info;
                if ((!file.isFile() || !file.getAbsolutePath().endsWith("midi")) && !file.getAbsolutePath().endsWith("mid") || (info = MidiFileInfo.fromFile(file)) == null) continue;
                this.songList.add(info);
            }
            if (!this.songList.isEmpty()) {
                this.selectSong(0);
            }
            return true;
        }
        return false;
    }

    public void playFromBeginning() {
        if (this.isSongLoaded().booleanValue()) {
            this.stop();
            this.lastTempoBPM = this.songList.get((int)this.selectedSongIndex.intValue()).tempo;
            this.activeSequencer.start();
        }
    }

    public void playFromLastTickPosition() {
        if (this.isPlaying().booleanValue()) {
            return;
        }
        if (this.isSongLoaded().booleanValue() && this.pausedTickPosition != null) {
            this.activeSequencer.stop();
            this.activeSequencer.setTickPosition(this.pausedTickPosition);
            this.activeSequencer.setTempoInBPM(this.lastTempoBPM.intValue());
            this.pausedTickPosition = null;
            this.pausedMicrosecond = null;
            this.activeSequencer.start();
        } else if (this.isSongLoaded().booleanValue()) {
            this.playFromBeginning();
        }
    }

    public void pause() {
        if (this.isSongLoaded().booleanValue() && this.isPlaying().booleanValue()) {
            this.pausedTickPosition = this.activeSequencer.getTickPosition();
            this.pausedMicrosecond = this.activeSequencer.getMicrosecondPosition();
            this.activeSequencer.stop();
        }
    }

    public void stop() {
        this.pausedTickPosition = null;
        this.pausedMicrosecond = null;
        if (this.isSongLoaded().booleanValue()) {
            this.activeSequencer.stop();
            this.activeSequencer.setTickPosition(0L);
        }
    }

    public void selectSong(Integer songNum) {
        Boolean play = false;
        if (this.isPlaying().booleanValue()) {
            play = true;
        }
        this.stop();
        this.selectedSongIndex = null;
        if (songNum != null && songNum >= 0 && songNum < this.songList.size()) {
            this.selectedSongIndex = songNum;
            this.loadSelectedSong();
            if (play.booleanValue()) {
                this.playFromBeginning();
            }
        }
    }

    public void shiftSong(Boolean up) {
        if (this.songList == null || this.songList.isEmpty()) {
            return;
        }
        if (!up.booleanValue()) {
            if (this.selectedSongIndex > 0) {
                this.selectSong(this.selectedSongIndex - 1);
            } else {
                this.selectSong(this.songList.size() - 1);
            }
        } else if (this.selectedSongIndex < this.songList.size() - 1) {
            this.selectSong(this.selectedSongIndex + 1);
        } else {
            this.selectSong(0);
        }
    }

    public void shiftLoopMode() {
        this.currentLoopMode = this.currentLoopMode == LoopMode.ALL ? LoopMode.SINGLE : (this.currentLoopMode == LoopMode.SINGLE ? LoopMode.NONE : LoopMode.ALL);
    }

    public Integer getLoopMode() {
        return this.currentLoopMode.ordinal();
    }

    public void shiftTransmitMode() {
        if (this.currentTransmitMode == TransmitterNotePacket.TransmitMode.PUBLIC) {
            this.stop();
            this.currentTransmitMode = TransmitterNotePacket.TransmitMode.LINKED;
        } else if (this.currentTransmitMode == TransmitterNotePacket.TransmitMode.LINKED) {
            this.stop();
            this.currentTransmitMode = TransmitterNotePacket.TransmitMode.SELF;
        } else {
            this.stop();
            this.currentTransmitMode = TransmitterNotePacket.TransmitMode.PUBLIC;
        }
    }

    public TransmitterNotePacket.TransmitMode getTransmitMode() {
        return this.currentTransmitMode;
    }

    public Integer getTransmitModeInt() {
        return this.currentTransmitMode.ordinal();
    }

    public Integer getShuffleMode() {
        return this.shuffled != false ? 1 : 0;
    }

    public Boolean toggleShuffle() {
        this.shuffled = this.shuffled == false;
        if (this.getSongCount() > 0 && this.shuffled.booleanValue()) {
            this.originalList = new ArrayList<MidiFileInfo>(this.songList);
            MidiFileInfo selectedSong = this.getSelectedSongInfo();
            Collections.shuffle(this.songList);
            this.selectedSongIndex = this.songList.indexOf(selectedSong);
        } else if (this.getSongCount() > 0) {
            MidiFileInfo selectedSong = this.getSelectedSongInfo();
            this.songList = this.originalList;
            this.originalList = new ArrayList<MidiFileInfo>();
            this.selectedSongIndex = this.songList.indexOf(selectedSong);
        }
        return this.shuffled;
    }

    public Integer getSongCount() {
        return this.songList.size();
    }

    public Boolean isPlaying() {
        return this.isSongLoaded() != false && this.activeSequencer.isRunning();
    }

    @Override
    protected void openTransmitter() {
        if (this.isOpen().booleanValue()) {
            try {
                this.activeTransmitter = this.activeSequencer.getTransmitter();
                this.activeReceiver = new MidiSequenceInputReceiver();
                this.activeTransmitter.setReceiver(this.activeReceiver);
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Midi Device Error: ", (Throwable)e);
                this.close();
            }
        }
    }

    @Override
    public void open() {
        if (!this.isOpen().booleanValue()) {
            try {
                this.activeSequencer = MidiSystem.getSequencer(false);
                this.activeSequencer.open();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.activeTransmitter == null) {
            this.openTransmitter();
        }
    }

    @Override
    public void close() {
        this.stop();
        super.close();
        this.activeReceiver = null;
        if (this.activeSequencer != null) {
            this.activeSequencer.close();
            this.activeSequencer = null;
        }
    }

    public static enum LoopMode {
        ALL,
        SINGLE,
        NONE;

    }
}

