/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.client.midi.MidiInputDeviceManager;
import io.github.tofodroid.mods.mimi.client.midi.MidiPlaylistManager;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.midi.AMidiInputManager;
import io.github.tofodroid.mods.mimi.common.network.TransmitterNotePacket;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MidiInputManager
extends AMidiInputManager {
    public final MidiInputDeviceManager inputDeviceManager;
    public final MidiPlaylistManager playlistManager;
    private Boolean hasTransmitter = false;
    private List<Object> localInstrumentToPlay = new ArrayList<Object>();

    public MidiInputManager() {
        this.inputDeviceManager = new MidiInputDeviceManager();
        this.playlistManager = new MidiPlaylistManager();
        this.playlistManager.open();
        this.inputDeviceManager.open();
    }

    @Override
    public Boolean hasTransmitter() {
        return this.hasTransmitter;
    }

    @Override
    public TransmitterNotePacket.TransmitMode getTransmitMode() {
        return this.playlistManager.getTransmitMode();
    }

    @Override
    public List<Pair<Byte, ItemStack>> getLocalInstrumentsForMidiDevice(PlayerEntity player, Byte channel) {
        return this.localInstrumentToPlay.stream().map(data -> {
            ItemStack switchStack = ItemStack.field_190927_a;
            Byte instrumentId = null;
            if (data instanceof ItemStack) {
                switchStack = ItemInstrument.getSwitchboardStack((ItemStack)data);
                instrumentId = ItemInstrument.getInstrumentId((ItemStack)data);
            } else if (data instanceof TileInstrument) {
                switchStack = ((TileInstrument)((Object)((Object)data))).getSwitchboardStack();
                instrumentId = ((TileInstrument)((Object)((Object)data))).getInstrumentId();
            }
            if (((Object)((Object)ModItems.SWITCHBOARD)).equals(switchStack.func_77973_b()) && ItemMidiSwitchboard.getSysInput(switchStack).booleanValue() && ItemMidiSwitchboard.isChannelEnabled(switchStack, channel).booleanValue()) {
                return new ImmutablePair((Object)instrumentId, (Object)switchStack);
            }
            return null;
        }).filter(b -> b != null).collect(Collectors.toList());
    }

    @Override
    @SubscribeEvent
    public void handleTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.CLIENT || !event.player.func_175144_cb()) {
            return;
        }
        if (this.hasTransmitter(event.player).booleanValue()) {
            this.hasTransmitter = true;
        } else {
            if (this.hasTransmitter.booleanValue()) {
                this.playlistManager.stop();
            }
            this.hasTransmitter = false;
        }
        this.localInstrumentToPlay = this.localInstrumentsToPlay(event.player);
    }

    @Override
    @SubscribeEvent
    public void handleSelfLogOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_175144_cb()) {
            this.playlistManager.stop();
        }
    }

    @Override
    @SubscribeEvent
    public void onDeathDevent(LivingDeathEvent event) {
        if (EntityType.field_200729_aH.equals(event.getEntity().func_200600_R()) && ((PlayerEntity)event.getEntity()).func_175144_cb()) {
            this.playlistManager.stop();
        }
    }

    protected Boolean hasTransmitter(PlayerEntity player) {
        if (player.field_71071_by != null) {
            if (((Object)((Object)ModItems.TRANSMITTER)).equals(player.func_184592_cb().func_77973_b())) {
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack == null || !((Object)((Object)ModItems.TRANSMITTER)).equals(invStack.func_77973_b())) continue;
                return true;
            }
            if (player.field_71071_by.func_70445_o() != null && ((Object)((Object)ModItems.TRANSMITTER)).equals(player.field_71071_by.func_70445_o().func_77973_b())) {
                return this.hasTransmitter;
            }
        }
        return false;
    }

    protected List<Object> localInstrumentsToPlay(PlayerEntity player) {
        ItemStack offHand;
        ItemStack mainHand;
        ArrayList<Object> result = new ArrayList<Object>();
        TileInstrument instrumentEntity = BlockInstrument.getTileInstrumentForEntity((LivingEntity)player);
        if (instrumentEntity != null && instrumentEntity.hasSwitchboard().booleanValue()) {
            result.add((Object)instrumentEntity);
        }
        if ((mainHand = ItemInstrument.getEntityHeldInstrumentStack((LivingEntity)player, Hand.MAIN_HAND)) != null && ItemInstrument.hasSwitchboard(mainHand).booleanValue()) {
            result.add(mainHand);
        }
        if ((offHand = ItemInstrument.getEntityHeldInstrumentStack((LivingEntity)player, Hand.OFF_HAND)) != null && ItemInstrument.hasSwitchboard(offHand).booleanValue()) {
            result.add(offHand);
        }
        return result;
    }
}

