/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.client.midi.MidiDeviceInputReceiver;
import io.github.tofodroid.mods.mimi.client.midi.MidiInputSourceManager;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;

public class MidiInputDeviceManager
extends MidiInputSourceManager {
    private String selectedDeviceName;
    private String midiDeviceError;
    private Boolean dirty = false;

    public MidiInputDeviceManager() {
        this.selectedDeviceName = (String)ModConfigs.CLIENT.selectedMidiDevice.get();
    }

    public Boolean isDeviceSelected() {
        return this.selectedDeviceName != null && !this.selectedDeviceName.trim().isEmpty();
    }

    public Boolean isDeviceAvailable() {
        return this.activeTransmitter != null;
    }

    public Boolean isDirtyStatus() {
        return this.dirty;
    }

    public String getSelectedDeviceName() {
        return this.selectedDeviceName;
    }

    public String getSelectedDeviceError() {
        return this.midiDeviceError;
    }

    public void saveDeviceSelection(MidiDevice device) {
        ModConfigs.CLIENT.selectedMidiDevice.set((Object)device.getDeviceInfo().getName());
        this.dirty = true;
    }

    public void clearDeviceSelection() {
        ModConfigs.CLIENT.selectedMidiDevice.set((Object)"");
        this.dirty = true;
    }

    public List<MidiDevice> getAvailableDevices() {
        List<MidiDevice> devices = new ArrayList<MidiDevice>();
        for (int i = 0; i < MidiSystem.getMidiDeviceInfo().length; ++i) {
            try {
                devices.add(MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[i]));
                continue;
            }
            catch (MidiUnavailableException e) {
                this.midiDeviceError = e.getMessage();
                MIMIMod.LOGGER.warn("Midi Device Error. Device will be skipped. Error: ", (Throwable)e);
            }
        }
        if (!devices.isEmpty()) {
            devices = devices.stream().filter(d -> d.getMaxTransmitters() != 0).filter(d -> !d.getClass().getName().contains("com.sun.media.sound.RealTimeSequencer")).collect(Collectors.toList());
        }
        return devices;
    }

    @Override
    protected void openTransmitter() {
        if (this.isDeviceSelected().booleanValue()) {
            try {
                String oldVal = System.setProperty("javax.sound.midi.Transmitter", "#" + this.selectedDeviceName);
                this.activeTransmitter = MidiSystem.getTransmitter();
                this.activeTransmitter.setReceiver(new MidiDeviceInputReceiver());
                if (oldVal != null) {
                    System.setProperty("javax.sound.midi.Transmitter", oldVal);
                } else {
                    System.clearProperty("javax.sound.midi.Transmitter");
                }
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Midi Device Error: ", (Throwable)e);
                this.close();
            }
        }
    }

    @Override
    public void open() {
        if (this.activeTransmitter == null) {
            this.openTransmitter();
        }
    }
}

