/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.common.midi.DrumKitName;
import io.github.tofodroid.mods.mimi.common.midi.MidiPatchName;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiFileInfo {
    public String fileName;
    public String songLength;
    public Integer tempo;
    public Map<Integer, String> instrumentMapping;

    public static MidiFileInfo fromFile(File file) {
        if (file.exists()) {
            try {
                Sequence sequence = MidiSystem.getSequence(file);
                MidiFileInfo result = new MidiFileInfo();
                result.instrumentMapping = MidiFileInfo.getInstrumentMapping(sequence);
                result.tempo = MidiFileInfo.getTempoBPM(sequence);
                result.fileName = file.getName();
                result.songLength = new Long(TimeUnit.MICROSECONDS.convert(sequence.getMicrosecondLength(), TimeUnit.SECONDS)).toString();
                return result;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static Map<Integer, String> getInstrumentMapping(Sequence sequence) {
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        for (int i = 0; i < 16; ++i) {
            mapping.put(i, null);
        }
        for (Track track : sequence.getTracks()) {
            if (track == null || track.size() <= 0) continue;
            for (int i = 0; i < track.size(); ++i) {
                if (!(track.get(i).getMessage() instanceof ShortMessage)) continue;
                ShortMessage message = (ShortMessage)track.get(i).getMessage();
                if (message.getChannel() != 9 && 192 == message.getCommand() && mapping.get(message.getChannel()) == null) {
                    mapping.put(message.getChannel(), MidiPatchName.getForPatch((Integer)Integer.valueOf((int)message.getData1())).name);
                    continue;
                }
                if (message.getChannel() == 9 && 192 == message.getCommand()) {
                    mapping.put(message.getChannel(), DrumKitName.getForPatch((Integer)Integer.valueOf((int)message.getData1())).name);
                    continue;
                }
                if (message.getChannel() != 9 || 144 != message.getCommand()) continue;
                mapping.put(message.getChannel(), DrumKitName.getForPatch((Integer)Integer.valueOf((int)0)).name);
            }
        }
        return mapping;
    }

    private static Integer getTempoBPM(Sequence sequence) {
        for (Track track : sequence.getTracks()) {
            if (track == null || track.size() <= 0) continue;
            for (int i = 0; i < track.size(); ++i) {
                MetaMessage message;
                if (!(track.get(i).getMessage() instanceof MetaMessage) || (message = (MetaMessage)track.get(i).getMessage()).getType() != 81 || message.getData().length != 3) continue;
                byte[] data = message.getData();
                int mspq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                return Math.round(6.0E7f / (float)mspq);
            }
        }
        return 120;
    }
}

