/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.client.midi.MidiInputReceiver;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkManager;
import io.github.tofodroid.mods.mimi.util.DebugUtils;
import javax.sound.midi.ShortMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class MidiDeviceInputReceiver
extends MidiInputReceiver {
    @Override
    protected void handleMessage(ShortMessage message, PlayerEntity player) {
        MIMIMod.proxy.getMidiInput().getLocalInstrumentsForMidiDevice(player, new Integer(message.getChannel()).byteValue()).forEach(pair -> {
            if (this.isNoteOnMessage(message).booleanValue()) {
                this.handleMidiNoteOn(new Integer(message.getChannel()).byteValue(), (Byte)pair.getLeft(), message.getMessage()[1], ItemMidiSwitchboard.applyVolume((ItemStack)pair.getRight(), message.getMessage()[2]), player);
            } else if (this.isNoteOffMessage(message).booleanValue()) {
                this.handleMidiNoteOff(new Integer(message.getChannel()).byteValue(), (Byte)pair.getLeft(), message.getMessage()[1], player);
            } else if (this.isAllNotesOffMessage(message).booleanValue()) {
                this.handleMidiNoteOff(new Integer(message.getChannel()).byteValue(), (Byte)pair.getLeft(), MidiNotePacket.ALL_NOTES_OFF, player);
            }
        });
    }

    public void handleMidiNoteOn(Byte channel, Byte instrument, Byte midiNote, Byte velocity, PlayerEntity player) {
        MidiNotePacket packet = new MidiNotePacket(midiNote, velocity, instrument, player.func_110124_au(), false, player.func_233580_cy_());
        NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
        DebugUtils.logNoteTimingInfo(this.getClass(), true, instrument, midiNote, velocity, player.func_233580_cy_());
        MIMIMod.proxy.getMidiSynth().handlePacket(packet);
    }

    public void handleMidiNoteOff(Byte channel, Byte instrument, Byte midiNote, PlayerEntity player) {
        MidiNotePacket packet = new MidiNotePacket(midiNote, Integer.valueOf(0).byteValue(), instrument, player.func_110124_au(), false, player.func_233580_cy_());
        NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
        DebugUtils.logNoteTimingInfo(this.getClass(), false, instrument, midiNote, null, null);
        MIMIMod.proxy.getMidiSynth().handlePacket(packet);
    }
}

