/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.common.tile.TileMechanicalMaestro;
import io.github.tofodroid.mods.mimi.util.DebugUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.sound.midi.MidiChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class MidiChannelDef {
    public static final Integer MIDI_CHANNEL_IDLE_SECONDS = 8;
    private final MidiChannel channel;
    private final Integer channelNum;
    private boolean assigned;
    private BlockPos lastNotePos;
    private Instant lastNoteTime;
    private Byte instrumentId;
    private Boolean mechanical;
    private UUID entityId;

    public MidiChannelDef(Integer channelNum, MidiChannel channel) {
        this.channelNum = channelNum;
        this.channel = channel;
        this.assigned = false;
    }

    public void assign(UUID entityId, Boolean mechanical, InstrumentSpec instrument) {
        this.assigned = true;
        this.entityId = entityId;
        this.mechanical = mechanical;
        this.instrumentId = instrument.instrumentId;
        this.channel.programChange(instrument.midiBankNumber, instrument.midiPatchNumber);
        this.channel.controlChange(7, 0);
    }

    public void reset() {
        this.assigned = false;
        this.mechanical = false;
        this.instrumentId = null;
        this.lastNotePos = null;
        this.lastNoteTime = null;
        this.entityId = null;
        this.channel.allNotesOff();
    }

    public void noteOn(InstrumentSpec instrument, Byte note, Byte velocity, BlockPos notePos) {
        this.channel.noteOn(note.byteValue(), velocity.byteValue());
        this.lastNotePos = notePos;
        this.lastNoteTime = Instant.now();
        DebugUtils.logNoteTimingInfo(this.getClass(), true, this.instrumentId, note, velocity, notePos);
    }

    public void noteOff(Byte note) {
        if (MidiNotePacket.ALL_NOTES_OFF.equals(note)) {
            this.channel.allNotesOff();
        } else {
            this.channel.noteOff(note.byteValue());
        }
        DebugUtils.logNoteTimingInfo(this.getClass(), false, this.instrumentId, note, null, null);
    }

    public Boolean tick(PlayerEntity clientPlayer) {
        if (!this.assigned) {
            MIMIMod.LOGGER.warn("Attempted to tick unassigned channel: " + this.channel.toString());
            return null;
        }
        Boolean clientChannel = this.isClientChannel(clientPlayer.func_110124_au());
        if (!this.isIdle().booleanValue() && (clientChannel.booleanValue() || !(Math.sqrt(clientPlayer.func_233580_cy_().func_177951_i((Vector3i)this.lastNotePos)) > 72.0)) && (!this.mechanical.booleanValue() && this.isPlayerUsingInstrument(clientPlayer.func_130014_f_()).booleanValue() || this.mechanical.booleanValue() && this.isMechanicalMaestroUsingInstrument(clientPlayer.func_130014_f_()).booleanValue())) {
            if (!clientChannel.booleanValue()) {
                this.setVolume(Math.sqrt(clientPlayer.func_233580_cy_().func_177951_i((Vector3i)this.lastNotePos)));
                this.setLRPan(clientPlayer.func_233580_cy_(), Float.valueOf(clientPlayer.func_70079_am()));
            } else {
                this.setVolume(0.0);
            }
            return true;
        }
        if (this.lastNoteTime != null) {
            return false;
        }
        MIMIMod.LOGGER.warn("Attempted to tick unassigned channel: " + this.channel.toString());
        return null;
    }

    public Boolean isPlayerUsingInstrument(World worldIn) {
        PlayerEntity player = worldIn.func_217371_b(this.entityId);
        if (player == null) {
            return false;
        }
        Byte checkId = ItemInstrument.getEntityHeldInstrumentId((LivingEntity)player, Hand.MAIN_HAND);
        if (checkId != null && checkId.equals(this.instrumentId)) {
            return true;
        }
        checkId = ItemInstrument.getEntityHeldInstrumentId((LivingEntity)player, Hand.OFF_HAND);
        if (checkId != null && checkId.equals(this.instrumentId)) {
            return true;
        }
        TileInstrument instrumentTile = BlockInstrument.getTileInstrumentForEntity((LivingEntity)player);
        Byte by = checkId = instrumentTile != null ? instrumentTile.getInstrumentId() : null;
        if (checkId != null && checkId.equals(this.instrumentId) && (this.lastNotePos == null || this.lastNotePos.equals((Object)player.func_233580_cy_()))) {
            return true;
        }
        return false;
    }

    public Boolean isMechanicalMaestroUsingInstrument(World worldIn) {
        TileMechanicalMaestro mech;
        TileEntity tile = worldIn.func_175625_s(this.lastNotePos);
        TileMechanicalMaestro tileMechanicalMaestro = mech = tile != null && ModTiles.MECHANICALMAESTRO.equals((Object)tile.func_200662_C()) ? (TileMechanicalMaestro)tile : null;
        if (mech == null) {
            return false;
        }
        Byte mechInstrument = mech.getInstrumentId();
        if (mechInstrument == null || mechInstrument != this.instrumentId) {
            return false;
        }
        if (mech.getSwitchboardStack().func_190926_b()) {
            return false;
        }
        return true;
    }

    public Integer getChannelNumber() {
        return this.channelNum;
    }

    private Boolean isClientChannel(UUID clientPlayerId) {
        return this.assigned && clientPlayerId.equals(this.entityId);
    }

    private Boolean isIdle() {
        if (this.lastNoteTime != null) {
            return Math.abs(ChronoUnit.SECONDS.between(Instant.now(), this.lastNoteTime)) > (long)MIDI_CHANNEL_IDLE_SECONDS.intValue();
        }
        return true;
    }

    protected Byte setVolume(Double distance) {
        Double volume = 127.0 - Math.floor(127.0 * Math.pow(distance, 2.5) / (Math.pow(distance, 2.5) + Math.pow(72.0 - distance, 2.5)));
        Float catVolume = Float.valueOf(Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.PLAYERS));
        catVolume = Float.valueOf(catVolume.floatValue() * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER));
        volume = (volume = Double.valueOf(volume * catVolume.doubleValue())) < 0.0 ? 0.0 : (volume > 127.0 ? 127.0 : volume);
        Byte byteVal = Integer.valueOf(volume.intValue()).byteValue();
        this.channel.controlChange(7, byteVal.byteValue());
        return byteVal;
    }

    protected Byte setLRPan(BlockPos playerPos, Float playerHeadRoationYaw) {
        Float posAngle = MidiChannelDef.angleBetween(playerPos, this.lastNotePos);
        Float headAngle = playerHeadRoationYaw;
        headAngle = Float.valueOf((headAngle.floatValue() < 0.0f ? headAngle.floatValue() + 360.0f : headAngle.floatValue()) % 360.0f);
        Double relativeAngle = (posAngle.doubleValue() - headAngle.doubleValue() + 630.0) % 360.0;
        Double relVal = 64.0 * Math.sin(Math.toRadians(relativeAngle));
        Integer lrPan = 63 + (relVal = Double.valueOf(relVal * 0.5)).intValue();
        lrPan = lrPan < 0 ? 0 : (lrPan > 127 ? 127 : lrPan);
        Byte byteVal = lrPan.byteValue();
        this.channel.controlChange(10, byteVal.byteValue());
        return byteVal;
    }

    protected static Float angleBetween(BlockPos source, BlockPos target) {
        Float angle = Float.valueOf((float)Math.toDegrees(Math.atan2(target.func_177952_p() - source.func_177952_p(), target.func_177958_n() - source.func_177958_n())));
        return Float.valueOf((angle.floatValue() < 0.0f ? angle.floatValue() + 360.0f : angle.floatValue()) % 360.0f);
    }
}

