/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.midi.MidiFileInfo;
import io.github.tofodroid.mods.mimi.client.midi.MidiInputManager;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ModConfigs;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.StringTextComponent;

public class GuiMidiPlaylist
extends BaseGui {
    private static final Integer DEFAULT_TEXT_FIELD_COLOR = 0xE0E0E0;
    private TextFieldWidget folderPathField;
    private String folderPathString;
    private static final Vector2f LOAD_FOLDER_BUTTON = new Vector2f(301.0f, 37.0f);
    private static final Vector2f SAVE_DEFAULT_BUTTON = new Vector2f(320.0f, 37.0f);
    private static final Vector2f LOAD_DEFAULT_BUTTON = new Vector2f(339.0f, 37.0f);
    private static final Vector2f PREVIOUS_BUTTON = new Vector2f(14.0f, 271.0f);
    private static final Vector2f STOP_BUTTON = new Vector2f(33.0f, 271.0f);
    private static final Vector2f PLAY_PAUSE_BUTTON = new Vector2f(52.0f, 271.0f);
    private static final Vector2f NEXT_BUTTON = new Vector2f(71.0f, 271.0f);
    private static final Vector2f LOOP_BUTTON = new Vector2f(90.0f, 271.0f);
    private static final Vector2f LOOP_SCREEN = new Vector2f(108.0f, 272.0f);
    private static final Vector2f SHUFFLE_BUTTON = new Vector2f(125.0f, 271.0f);
    private static final Vector2f SHUFFLE_SCREEN = new Vector2f(143.0f, 272.0f);
    private static final Vector2f TRANSMIT_BUTTON = new Vector2f(160.0f, 271.0f);
    private static final Vector2f TRANSMIT_SCREEN = new Vector2f(178.0f, 272.0f);
    private static final Integer SLIDE_Y = 270;
    private static final Integer SLIDE_MIN_X = 205;
    private static final Integer SLIDE_MAX_X = 339;
    private static final Integer SLIDE_WIDTH = SLIDE_MAX_X - SLIDE_MIN_X;
    private MidiInputManager midiInputManager = (MidiInputManager)MIMIMod.proxy.getMidiInput();

    public GuiMidiPlaylist(PlayerEntity player) {
        super(368, 300, 400, "textures/gui/gui_midi_playlist.png", "item.MIMIMod.gui_midi_playlist");
        this.folderPathString = this.midiInputManager.playlistManager.getPlaylistFolderPath();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.folderPathField = (TextFieldWidget)this.func_230481_d_((IGuiEventListener)new TextFieldWidget(this.field_230712_o_, this.START_X + 90, this.START_Y + 40, 207, 10, StringTextComponent.field_240750_d_));
        this.folderPathField.func_146180_a(this.folderPathString);
        this.folderPathField.func_146203_f(256);
        this.folderPathField.func_212954_a(this::handlePathChange);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int imouseX = (int)Math.round(mouseX);
        int imouseY = (int)Math.round(mouseY);
        if (this.folderPathString != null && this.clickedBox(imouseX, imouseY, LOAD_FOLDER_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.loadFromFolder(this.folderPathString);
        } else if (this.folderPathString != null && this.clickedBox(imouseX, imouseY, SAVE_DEFAULT_BUTTON).booleanValue()) {
            ModConfigs.CLIENT.playlistFolderPath.set((Object)this.folderPathString);
        } else if (ModConfigs.CLIENT.playlistFolderPath.get() != null && !((String)ModConfigs.CLIENT.playlistFolderPath.get()).isEmpty() && this.clickedBox(imouseX, imouseY, LOAD_DEFAULT_BUTTON).booleanValue()) {
            this.folderPathString = (String)ModConfigs.CLIENT.playlistFolderPath.get();
            this.folderPathField.func_146180_a(this.folderPathString);
            this.midiInputManager.playlistManager.loadFromFolder(this.folderPathString);
        } else if (this.clickedBox(imouseX, imouseY, PREVIOUS_BUTTON).booleanValue()) {
            Double slidePercentage = null;
            if (this.midiInputManager.playlistManager.isSongLoaded().booleanValue()) {
                slidePercentage = new Double(this.midiInputManager.playlistManager.getCurrentSongPosSeconds().intValue()) / new Double(this.midiInputManager.playlistManager.getSongLengthSeconds().intValue());
            }
            if (slidePercentage != null && slidePercentage >= 0.25) {
                this.midiInputManager.playlistManager.playFromBeginning();
            } else {
                this.midiInputManager.playlistManager.shiftSong(false);
            }
        } else if (this.clickedBox(imouseX, imouseY, STOP_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.stop();
        } else if (this.clickedBox(imouseX, imouseY, PLAY_PAUSE_BUTTON).booleanValue()) {
            if (this.midiInputManager.playlistManager.isPlaying().booleanValue()) {
                this.midiInputManager.playlistManager.pause();
            } else {
                this.midiInputManager.playlistManager.playFromLastTickPosition();
            }
        } else if (this.clickedBox(imouseX, imouseY, NEXT_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.shiftSong(true);
        } else if (this.clickedBox(imouseX, imouseY, LOOP_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.shiftLoopMode();
        } else if (this.clickedBox(imouseX, imouseY, SHUFFLE_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.toggleShuffle();
        } else if (this.clickedBox(imouseX, imouseY, TRANSMIT_BUTTON).booleanValue()) {
            this.midiInputManager.playlistManager.shiftTransmitMode();
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return !this.folderPathField.func_231046_a_(keyCode, scanCode, modifiers) && !this.folderPathField.func_212955_f() ? super.func_231046_a_(keyCode, scanCode, modifiers) : true;
    }

    @Override
    protected MatrixStack renderGraphics(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.guiTexture);
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)this.START_X, (int)this.START_Y, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.GUI_WIDTH, (int)this.GUI_HEIGHT, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        if (this.midiInputManager.playlistManager.isSongSelected().booleanValue()) {
            Integer songOffset = this.midiInputManager.playlistManager.getSongCount() <= 6 || this.midiInputManager.playlistManager.getSelectedSongIndex() < 3 ? this.midiInputManager.playlistManager.getSelectedSongIndex() : (this.midiInputManager.playlistManager.getSelectedSongIndex() > this.midiInputManager.playlistManager.getSongCount() - 3 ? Integer.valueOf(6 - (this.midiInputManager.playlistManager.getSongCount() - this.midiInputManager.playlistManager.getSelectedSongIndex())) : Integer.valueOf(3));
            Integer boxY = 82 + 10 * songOffset;
            GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + 15), (int)(this.START_Y + boxY), (int)this.func_230927_p_(), (float)1.0f, (float)301.0f, (int)338, (int)11, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + 53), (int)(this.START_Y + 272), (int)this.func_230927_p_(), (float)(1 + this.midiInputManager.playlistManager.isPlaying().compareTo(false) * 13), (float)355.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + new Float(GuiMidiPlaylist.LOOP_SCREEN.field_189982_i).intValue()), (int)(this.START_Y + new Float(GuiMidiPlaylist.LOOP_SCREEN.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)(1 + 13 * this.midiInputManager.playlistManager.getLoopMode()), (float)313.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + new Float(GuiMidiPlaylist.SHUFFLE_SCREEN.field_189982_i).intValue()), (int)(this.START_Y + new Float(GuiMidiPlaylist.SHUFFLE_SCREEN.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)(1 + 13 * this.midiInputManager.playlistManager.getShuffleMode()), (float)327.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + new Float(GuiMidiPlaylist.TRANSMIT_SCREEN.field_189982_i).intValue()), (int)(this.START_Y + new Float(GuiMidiPlaylist.TRANSMIT_SCREEN.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)(1 + 13 * this.midiInputManager.playlistManager.getTransmitModeInt()), (float)341.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        Integer slideOffset = 0;
        if (this.midiInputManager.playlistManager.isSongLoaded().booleanValue()) {
            Integer slideLength = this.midiInputManager.playlistManager.getSongLengthSeconds();
            Integer slideProgress = this.midiInputManager.playlistManager.getCurrentSongPosSeconds();
            Double slidePercentage = new Double(slideProgress.intValue()) / new Double(slideLength.intValue());
            slideOffset = new Double(Math.floor(slidePercentage * (double)SLIDE_WIDTH.intValue())).intValue();
        }
        GuiMidiPlaylist.func_238464_a_((MatrixStack)matrixStack, (int)(this.START_X + SLIDE_MIN_X + slideOffset), (int)(this.START_Y + SLIDE_Y), (int)this.func_230927_p_(), (float)43.0f, (float)313.0f, (int)7, (int)17, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        this.folderPathField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        return matrixStack;
    }

    @Override
    protected MatrixStack renderText(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        MidiFileInfo info;
        if (this.midiInputManager.playlistManager.getSongCount() > 0) {
            Integer minSong = this.midiInputManager.playlistManager.getSongCount() <= 6 || this.midiInputManager.playlistManager.getSelectedSongIndex() < 3 ? Integer.valueOf(0) : (this.midiInputManager.playlistManager.getSelectedSongIndex() > this.midiInputManager.playlistManager.getSongCount() - 3 ? Integer.valueOf(this.midiInputManager.playlistManager.getSongCount() - 6) : Integer.valueOf(this.midiInputManager.playlistManager.getSelectedSongIndex() - 3));
            for (int i = 0; i < 6 && this.midiInputManager.playlistManager.getSongCount() > minSong + i; ++i) {
                MidiFileInfo info2 = this.midiInputManager.playlistManager.getLoadedPlaylist().get(minSong + i);
                this.field_230712_o_.func_238421_b_(matrixStack, minSong + i + 1 + "). " + (info2.fileName.length() > 50 ? info2.fileName.substring(0, 50) + "..." : info2.fileName), (float)(this.START_X + 18), (float)(this.START_Y + 84 + i * 10), -16718336);
            }
        }
        if ((info = this.midiInputManager.playlistManager.getSelectedSongInfo()) != null) {
            Integer n;
            Integer n2;
            String name;
            this.field_230712_o_.func_238421_b_(matrixStack, "Channel Instruments: ", (float)(this.START_X + 16), (float)(this.START_Y + 174), -16718336);
            Integer index = 0;
            Integer i = 0;
            while (i < 16) {
                name = info.instrumentMapping.get(i) == null ? "None" : info.instrumentMapping.get(i);
                this.field_230712_o_.func_238421_b_(matrixStack, i + 1 + ": " + name, (float)(this.START_X + 16), (float)(this.START_Y + 188 + 10 * index), -16718336);
                n2 = index;
                n = index = Integer.valueOf(index + 1);
                i = i + 2;
            }
            index = 0;
            i = 1;
            while (i < 16) {
                name = info.instrumentMapping.get(i) == null ? "None" : info.instrumentMapping.get(i);
                this.field_230712_o_.func_238421_b_(matrixStack, i + 1 + ": " + name, (float)(this.START_X + 184), (float)(this.START_Y + 188 + 10 * index), -16718336);
                n2 = index;
                n = index = Integer.valueOf(index + 1);
                i = i + 2;
            }
        }
        return matrixStack;
    }

    protected void handlePathChange(String folderPath) {
        if (folderPath != null && !folderPath.trim().isEmpty()) {
            try {
                if (!Files.isDirectory(Paths.get(folderPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    throw new RuntimeException("Folder not found: " + folderPath);
                }
                this.folderPathString = folderPath.trim();
                this.folderPathField.func_146193_g(DEFAULT_TEXT_FIELD_COLOR.intValue());
            }
            catch (Exception e) {
                this.folderPathString = null;
                this.folderPathField.func_146193_g(13112340);
            }
        } else {
            this.folderPathString = null;
            this.folderPathField.func_146193_g(13112340);
        }
    }
}

