/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.midi.MidiInputManager;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import java.util.List;
import javax.sound.midi.MidiDevice;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector2f;

public class GuiMidiInputConfig
extends BaseGui {
    private static final Vector2f CLEAR_DEVICE_BUTTON = new Vector2f(272.0f, 36.0f);
    private static final Vector2f REFRESH_DEVICES_BUTTON = new Vector2f(271.0f, 94.0f);
    private static final Vector2f SHIFT_DEVICE_DOWN_BUTTON = new Vector2f(110.0f, 94.0f);
    private static final Vector2f SHIFT_DEVICE_UP_BUTTON = new Vector2f(252.0f, 94.0f);
    private static final Vector2f SAVE_DEVICE_BUTTON = new Vector2f(271.0f, 144.0f);
    private MidiInputManager midiInputManager = (MidiInputManager)MIMIMod.proxy.getMidiInput();
    private List<MidiDevice> availableDevices;
    private Integer visibleDeviceId = 0;

    public GuiMidiInputConfig(PlayerEntity player) {
        super(300, 173, 300, "textures/gui/gui_midi_config.png", "item.MIMIMod.gui_midi_input_config");
        this.availableDevices = this.midiInputManager.inputDeviceManager.getAvailableDevices();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int imouseX = (int)Math.round(mouseX);
        int imouseY = (int)Math.round(mouseY);
        if (this.clickedBox(imouseX, imouseY, REFRESH_DEVICES_BUTTON).booleanValue()) {
            this.visibleDeviceId = 0;
            this.availableDevices = this.midiInputManager.inputDeviceManager.getAvailableDevices();
        } else if (this.midiInputManager.inputDeviceManager.isDeviceSelected().booleanValue() && this.clickedBox(imouseX, imouseY, CLEAR_DEVICE_BUTTON).booleanValue()) {
            this.midiInputManager.inputDeviceManager.clearDeviceSelection();
        } else if (this.availableDevices != null && this.availableDevices.size() > this.visibleDeviceId && this.clickedBox(imouseX, imouseY, SAVE_DEVICE_BUTTON).booleanValue()) {
            this.midiInputManager.inputDeviceManager.saveDeviceSelection(this.availableDevices.get(this.visibleDeviceId));
        } else if (this.availableDevices != null && this.clickedBox(imouseX, imouseY, SHIFT_DEVICE_UP_BUTTON).booleanValue()) {
            this.visibleDeviceId = this.visibleDeviceId < this.availableDevices.size() - 1 ? this.visibleDeviceId + 1 : this.visibleDeviceId;
        } else if (this.availableDevices != null && this.clickedBox(imouseX, imouseY, SHIFT_DEVICE_DOWN_BUTTON).booleanValue()) {
            this.visibleDeviceId = this.visibleDeviceId > 0 ? this.visibleDeviceId - 1 : this.visibleDeviceId;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    protected MatrixStack renderGraphics(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.guiTexture);
        GuiMidiInputConfig.func_238464_a_((MatrixStack)matrixStack, (int)this.START_X, (int)this.START_Y, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.GUI_WIDTH, (int)this.GUI_HEIGHT, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        Integer statusX = this.START_X + 265;
        Integer statusY = this.START_Y + 42;
        if (this.midiInputManager.inputDeviceManager.isDirtyStatus().booleanValue()) {
            GuiMidiInputConfig.func_238464_a_((MatrixStack)matrixStack, (int)statusX, (int)statusY, (int)this.func_230927_p_(), (float)8.0f, (float)159.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        } else if (this.midiInputManager.inputDeviceManager.isDeviceSelected().booleanValue()) {
            GuiMidiInputConfig.func_238464_a_((MatrixStack)matrixStack, (int)statusX, (int)statusY, (int)this.func_230927_p_(), (float)(this.midiInputManager.inputDeviceManager.isDeviceAvailable() != false ? 0.0f : 4.0f), (float)159.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        return matrixStack;
    }

    @Override
    protected MatrixStack renderText(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.midiInputManager.inputDeviceManager.isDeviceSelected().booleanValue()) {
            this.field_230712_o_.func_238421_b_(matrixStack, this.midiInputManager.inputDeviceManager.getSelectedDeviceName(), (float)(this.START_X + 123), (float)(this.START_Y + 40), -16718336);
        }
        if (this.availableDevices != null && this.availableDevices.size() > this.visibleDeviceId) {
            this.field_230712_o_.func_238421_b_(matrixStack, this.visibleDeviceId + ": " + this.availableDevices.get(this.visibleDeviceId).getDeviceInfo().getName(), (float)(this.START_X + 131), (float)(this.START_Y + 98), -16718336);
            MidiDevice.Info info = this.availableDevices.get(this.visibleDeviceId).getDeviceInfo();
            if (info != null) {
                String descString = "Description: " + info.getDescription();
                Integer yOffset = 0;
                if (descString.length() <= 45) {
                    this.field_230712_o_.func_238421_b_(matrixStack, descString, (float)(this.START_X + 16), (float)(this.START_Y + 115), -16718336);
                } else {
                    yOffset = 16;
                    this.field_230712_o_.func_238421_b_(matrixStack, descString.substring(0, 45), (float)(this.START_X + 16), (float)(this.START_Y + 115), -16718336);
                    this.field_230712_o_.func_238421_b_(matrixStack, descString.substring(45), (float)(this.START_X + 16), (float)(this.START_Y + 131), -16718336);
                }
                this.field_230712_o_.func_238421_b_(matrixStack, "Vendor: " + info.getVendor(), (float)(this.START_X + 16), (float)(this.START_Y + yOffset + 131), -16718336);
                this.field_230712_o_.func_238421_b_(matrixStack, "Version: " + info.getVersion(), (float)(this.START_X + 16), (float)(this.START_Y + yOffset + 147), -16718336);
            }
        }
        return matrixStack;
    }
}

