/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.tofodroid.mods.mimi.client.gui.ASwitchboardGui;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ClientConfig;
import io.github.tofodroid.mods.mimi.common.config.ModConfigs;
import io.github.tofodroid.mods.mimi.common.container.ContainerInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.network.MidiNotePacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkManager;
import io.github.tofodroid.mods.mimi.common.network.SyncItemInstrumentSwitchboardPacket;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.DebugUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Hand;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.glfw.GLFW;

public class GuiInstrumentContainerScreen
extends ASwitchboardGui<ContainerInstrument> {
    private static final Integer NOTE_WIDTH = 14;
    private static final Integer NOTE_OFFSET_X = 11;
    private static final Integer NOTE_OFFSET_Y = 29;
    private static final Vector2f SYS_DEVICE_BUTTON_COORDS = new Vector2f(105.0f, 84.0f);
    private static final Vector2f SOURCE_SELF_BUTTON_COORDS = new Vector2f(47.0f, 133.0f);
    private static final Vector2f SOURCE_PUBLIC_BUTTON_COORDS = new Vector2f(66.0f, 133.0f);
    private static final Vector2f SOURCE_CLEAR_BUTTON_COORDS = new Vector2f(85.0f, 133.0f);
    private static final Vector2f KEYBOARD_LAYOUT_BUTTON_COORDS = new Vector2f(300.0f, 31.0f);
    private static final Vector2f ALL_MIDI_BUTTON_COORDS = new Vector2f(141.0f, 101.0f);
    private static final Vector2f CLEAR_MIDI_BUTTON_COORDS = new Vector2f(141.0f, 126.0f);
    private static final Vector2f GEN_MIDI_BUTTON_COORDS = new Vector2f(160.0f, 101.0f);
    private static final Vector2f NOTE_SHIFT_DOWN_BUTTON_COORDS = new Vector2f(14.0f, 177.0f);
    private static final Vector2f NOTE_SHIFT_UP_BUTTON_COORDS = new Vector2f(59.0f, 177.0f);
    private static final Vector2f OCT_SHIFT_DOWN_BUTTON_COORDS = new Vector2f(84.0f, 177.0f);
    private static final Vector2f OCT_SHIFT_UP_BUTTON_COORDS = new Vector2f(129.0f, 177.0f);
    private static final Vector2f SWITCHBOARD_EDIT_BUTTON_COORDS = new Vector2f(105.0f, 219.0f);
    private static final Vector2f INSTRUMENT_VOLUME_UP_BUTTON_COORDS = new Vector2f(202.0f, 58.0f);
    private static final Vector2f INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS = new Vector2f(155.0f, 58.0f);
    private static final Integer KEYBOARD_START_NOTE = 21;
    private static final Integer VISIBLE_NOTES = 44;
    private static final Integer MAX_NOTE_SHIFT = 53;
    private final Integer ACCENT_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)83);
    private final Integer ACCENT_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)39);
    private final Integer ACCENT_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)49);
    private final Integer ACCENT_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)61);
    private final Integer NOTE_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)90);
    private final Integer NOTE_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)47);
    private final Integer NOTE_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)81);
    private final Integer NOTE_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)93);
    private final Integer V_PIANO_MIN_SHIFT = 14;
    private final Integer V_PIANO_MAX_SHIFT = 28;
    private final Integer V_PIANO_MAX_NOTE = 49;
    private final Map<Integer, Integer> VPianoMidiMap = Stream.of({GLFW.glfwGetKeyScancode((int)49), 0}, {-GLFW.glfwGetKeyScancode((int)49), 1}, {GLFW.glfwGetKeyScancode((int)50), 2}, {-GLFW.glfwGetKeyScancode((int)50), 3}, {GLFW.glfwGetKeyScancode((int)51), 4}, {GLFW.glfwGetKeyScancode((int)52), 5}, {-GLFW.glfwGetKeyScancode((int)52), 6}, {GLFW.glfwGetKeyScancode((int)53), 7}, {-GLFW.glfwGetKeyScancode((int)53), 8}, {GLFW.glfwGetKeyScancode((int)54), 9}, {-GLFW.glfwGetKeyScancode((int)54), 10}, {GLFW.glfwGetKeyScancode((int)55), 11}, {GLFW.glfwGetKeyScancode((int)56), 12}, {-GLFW.glfwGetKeyScancode((int)56), 13}, {GLFW.glfwGetKeyScancode((int)57), 14}, {-GLFW.glfwGetKeyScancode((int)57), 15}, {GLFW.glfwGetKeyScancode((int)48), 16}, {GLFW.glfwGetKeyScancode((int)81), 17}, {-GLFW.glfwGetKeyScancode((int)81), 18}, {GLFW.glfwGetKeyScancode((int)87), 19}, {-GLFW.glfwGetKeyScancode((int)87), 20}, {GLFW.glfwGetKeyScancode((int)69), 21}, {-GLFW.glfwGetKeyScancode((int)69), 22}, {GLFW.glfwGetKeyScancode((int)82), 23}, {GLFW.glfwGetKeyScancode((int)84), 24}, {-GLFW.glfwGetKeyScancode((int)84), 25}, {GLFW.glfwGetKeyScancode((int)89), 26}, {-GLFW.glfwGetKeyScancode((int)89), 27}, {GLFW.glfwGetKeyScancode((int)85), 28}, {GLFW.glfwGetKeyScancode((int)73), 29}, {-GLFW.glfwGetKeyScancode((int)73), 30}, {GLFW.glfwGetKeyScancode((int)79), 31}, {-GLFW.glfwGetKeyScancode((int)79), 32}, {GLFW.glfwGetKeyScancode((int)80), 33}, {-GLFW.glfwGetKeyScancode((int)80), 34}, {GLFW.glfwGetKeyScancode((int)65), 35}, {GLFW.glfwGetKeyScancode((int)83), 36}, {-GLFW.glfwGetKeyScancode((int)83), 37}, {GLFW.glfwGetKeyScancode((int)68), 38}, {-GLFW.glfwGetKeyScancode((int)68), 39}, {GLFW.glfwGetKeyScancode((int)70), 40}, {GLFW.glfwGetKeyScancode((int)71), 41}, {-GLFW.glfwGetKeyScancode((int)71), 42}, {GLFW.glfwGetKeyScancode((int)72), 43}, {-GLFW.glfwGetKeyScancode((int)72), 44}, {GLFW.glfwGetKeyScancode((int)74), 45}, {-GLFW.glfwGetKeyScancode((int)74), 46}, {GLFW.glfwGetKeyScancode((int)75), 47}, {GLFW.glfwGetKeyScancode((int)76), 48}, {-GLFW.glfwGetKeyScancode((int)76), 49}, {GLFW.glfwGetKeyScancode((int)90), 50}, {-GLFW.glfwGetKeyScancode((int)90), 51}, {GLFW.glfwGetKeyScancode((int)88), 52}, {GLFW.glfwGetKeyScancode((int)67), 53}, {-GLFW.glfwGetKeyScancode((int)67), 54}, {GLFW.glfwGetKeyScancode((int)86), 55}, {-GLFW.glfwGetKeyScancode((int)86), 56}, {GLFW.glfwGetKeyScancode((int)66), 57}, {-GLFW.glfwGetKeyScancode((int)66), 58}, {GLFW.glfwGetKeyScancode((int)78), 59}, {GLFW.glfwGetKeyScancode((int)77), 60}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private final Byte instrumentId;
    private final Hand handIn;
    private final BlockPos tilePos;
    private ConcurrentHashMap<Byte, Instant> heldNotes;
    private ConcurrentHashMap<Byte, Instant> releasedNotes;
    private String instrumentNameString;
    private Boolean editMode = false;
    private Integer visibleNoteShift = KEYBOARD_START_NOTE;
    private String noteIdString = "C3,F4 | G4,C6";
    private Byte mouseNote = null;

    public GuiInstrumentContainerScreen(ContainerInstrument container, PlayerInventory inv, ITextComponent textComponent) {
        super(container, inv, 328, 250, 530, "textures/gui/container_instrument.png", textComponent);
        this.instrumentId = container.getInstrumentId();
        if (container.isHandheld().booleanValue()) {
            this.handIn = container.getHandIn();
            this.tilePos = null;
        } else {
            this.handIn = null;
            this.tilePos = container.getTilePos();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.heldNotes = new ConcurrentHashMap();
        this.releasedNotes = new ConcurrentHashMap();
        this.instrumentNameString = ((ContainerInstrument)this.field_147002_h).isHandheld() != false ? ItemInstrument.getInstrumentName(this.player.func_184586_b(this.handIn)) : ((TileInstrument)this.field_230706_i_.field_71441_e.func_175625_s(this.tilePos)).getInstrumentName();
    }

    @Override
    protected Boolean shouldRenderBackground() {
        return false;
    }

    public void func_231175_as__() {
        this.allNotesOff();
        super.func_231175_as__();
    }

    public boolean func_231044_a_(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        int firstNoteX = this.field_147003_i + NOTE_OFFSET_X;
        int firstNoteY = this.field_147009_r + NOTE_OFFSET_Y;
        int relativeMouseX = imouseX - firstNoteX;
        int relativeMouseY = imouseY - firstNoteY;
        if (this.clickedBox(imouseX, imouseY, SWITCHBOARD_EDIT_BUTTON_COORDS).booleanValue() && this.selectedSwitchboardStack != null) {
            this.editMode = this.editMode == false;
        } else if (!this.editMode.booleanValue()) {
            if (imouseX >= 220 && imouseY >= 28 && imouseX < this.field_147003_i + this.field_146999_f && imouseY < this.field_147009_r + 50) {
                if (this.clickedBox(imouseX, imouseY, KEYBOARD_LAYOUT_BUTTON_COORDS).booleanValue()) {
                    if (((ClientConfig.KEYBOARD_LAYOUTS)((Object)ModConfigs.CLIENT.keyboardLayout.get())).ordinal() < ClientConfig.KEYBOARD_LAYOUTS.values().length - 1) {
                        ModConfigs.CLIENT.keyboardLayout.set((Object)ClientConfig.KEYBOARD_LAYOUTS.values()[((ClientConfig.KEYBOARD_LAYOUTS)((Object)ModConfigs.CLIENT.keyboardLayout.get())).ordinal() + 1]);
                    } else {
                        ModConfigs.CLIENT.keyboardLayout.set((Object)ClientConfig.KEYBOARD_LAYOUTS.values()[0]);
                    }
                    this.allNotesOff();
                }
                return super.func_231044_a_(dmouseX, dmouseY, mouseButton);
            }
            if (relativeMouseX >= 0 && relativeMouseY >= 0 && imouseX < this.field_147003_i + this.field_146999_f - 11 && imouseY < this.field_147009_r + this.field_147000_g - 95) {
                Byte midiNote = null;
                if (relativeMouseY <= 84) {
                    midiNote = this.keyNumToMidiNote(2 * ((relativeMouseX + NOTE_WIDTH / 2) / NOTE_WIDTH));
                }
                if (midiNote == null) {
                    midiNote = this.keyNumToMidiNote(2 * (relativeMouseX / NOTE_WIDTH) + 1);
                }
                if (midiNote != null) {
                    this.mouseNote = midiNote;
                    this.onGuiNotePress(midiNote, (byte)127);
                }
            }
            if (this.clickedBox(imouseX, imouseY, NOTE_SHIFT_UP_BUTTON_COORDS).booleanValue()) {
                this.shiftVisibleNotes(true, 1);
            } else if (this.clickedBox(imouseX, imouseY, NOTE_SHIFT_DOWN_BUTTON_COORDS).booleanValue()) {
                this.shiftVisibleNotes(false, 1);
            } else if (this.clickedBox(imouseX, imouseY, OCT_SHIFT_UP_BUTTON_COORDS).booleanValue()) {
                this.shiftVisibleNotes(true, 7);
            } else if (this.clickedBox(imouseX, imouseY, OCT_SHIFT_DOWN_BUTTON_COORDS).booleanValue()) {
                this.shiftVisibleNotes(false, 7);
            }
        } else if (this.clickedBox(imouseX, imouseY, SYS_DEVICE_BUTTON_COORDS).booleanValue()) {
            ItemMidiSwitchboard.setSysInput(this.selectedSwitchboardStack, ItemMidiSwitchboard.getSysInput(this.selectedSwitchboardStack) == false);
            this.syncSwitchboardToServer();
        } else if (this.clickedBox(imouseX, imouseY, SOURCE_SELF_BUTTON_COORDS).booleanValue()) {
            this.setSelfSource();
        } else if (this.clickedBox(imouseX, imouseY, SOURCE_PUBLIC_BUTTON_COORDS).booleanValue()) {
            this.setPublicSource();
        } else if (this.clickedBox(imouseX, imouseY, SOURCE_CLEAR_BUTTON_COORDS).booleanValue()) {
            this.clearSource();
        } else if (this.clickedBox(imouseX, imouseY, INSTRUMENT_VOLUME_UP_BUTTON_COORDS).booleanValue()) {
            this.changeVolume(1);
        } else if (this.clickedBox(imouseX, imouseY, INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS).booleanValue()) {
            this.changeVolume(-1);
        } else if (this.clickedBox(imouseX, imouseY, CLEAR_MIDI_BUTTON_COORDS).booleanValue()) {
            this.clearChannels();
        } else if (this.clickedBox(imouseX, imouseY, ALL_MIDI_BUTTON_COORDS).booleanValue()) {
            this.enableAllChannels();
        } else {
            for (int i = 0; i < 16; ++i) {
                Vector2f buttonCoords = new Vector2f(GuiInstrumentContainerScreen.GEN_MIDI_BUTTON_COORDS.field_189982_i + (float)(i % 8 * 19), GuiInstrumentContainerScreen.GEN_MIDI_BUTTON_COORDS.field_189983_j + (float)(i / 8 * 25));
                if (!this.clickedBox(imouseX, imouseY, buttonCoords).booleanValue()) continue;
                this.toggleChannel(i);
                return super.func_231044_a_(dmouseX, dmouseY, mouseButton);
            }
        }
        return super.func_231044_a_(dmouseX, dmouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.mouseNote != null) {
            this.onGuiNoteRelease(this.mouseNote);
            this.mouseNote = null;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        super.func_231046_a_(keyCode, scanCode, modifiers);
        if (keyCode == 263) {
            this.shiftVisibleNotes(false, 1);
        } else if (keyCode == 262) {
            this.shiftVisibleNotes(true, 1);
        } else if (keyCode == 264) {
            this.shiftVisibleNotes(false, 7);
        } else if (keyCode == 265) {
            this.shiftVisibleNotes(true, 7);
        } else {
            Set<Byte> midiNoteNums = this.getMidiNoteFromScanCode(scanCode, modifiers == 1, false);
            if (midiNoteNums != null) {
                for (Byte midiNoteNum : midiNoteNums) {
                    if (this.heldNotes.containsKey(midiNoteNum)) continue;
                    this.onGuiNotePress(midiNoteNum, (byte)127);
                }
            }
        }
        return true;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        super.func_223281_a_(keyCode, scanCode, modifiers);
        Set<Byte> midiNoteNums = this.getMidiNoteFromScanCode(scanCode, modifiers == 1, true);
        if (midiNoteNums != null) {
            for (Byte midiNoteNum : midiNoteNums) {
                this.onGuiNoteRelease(midiNoteNum);
            }
        }
        return true;
    }

    @Override
    public void loadSelectedSwitchboard() {
        super.loadSelectedSwitchboard();
        this.allNotesOff();
        this.syncInstrumentToServer();
    }

    @Override
    public void clearSwitchboard() {
        super.clearSwitchboard();
        this.editMode = false;
        this.allNotesOff();
        this.syncInstrumentToServer();
    }

    private Byte keyNumToMidiNote(Integer keyNum) {
        if (keyNum == null) {
            return null;
        }
        Byte result = null;
        Integer octaveNote = (keyNum + 2 * this.visibleNoteShift) % 14;
        Integer octaveNum = (keyNum + 2 * this.visibleNoteShift) / 14;
        if (octaveNote != 0 && octaveNote != 6) {
            octaveNote = octaveNote - (octaveNote > 6 ? 2 : 1);
            result = new Integer(octaveNote + 12 * octaveNum).byteValue();
        }
        return result;
    }

    private Integer midiNoteToKeyNum(Byte midiNote) {
        if (midiNote == null) {
            return null;
        }
        Integer octaveNote = midiNote % 12;
        Integer octaveNum = midiNote / 12;
        Integer result = (octaveNote = Integer.valueOf(octaveNote + (octaveNote > 4 ? 2 : 1))) + 14 * octaveNum - 2 * this.visibleNoteShift;
        if (result >= 0 && result <= VISIBLE_NOTES) {
            return result;
        }
        return null;
    }

    private void shiftVisibleNotes(Boolean up, Integer amount) {
        this.visibleNoteShift = up != false ? Integer.valueOf(this.visibleNoteShift + amount) : Integer.valueOf(this.visibleNoteShift - amount);
        this.visibleNoteShift = this.visibleNoteShift < 0 ? 0 : (this.visibleNoteShift > MAX_NOTE_SHIFT ? MAX_NOTE_SHIFT : this.visibleNoteShift);
        this.noteIdString = this.buildNoteIdString();
    }

    public void onMidiNoteOn(Byte channel, Byte midiNote, Byte velocity) {
        this.holdNote(midiNote, velocity);
    }

    public void onMidiNoteOff(Byte channel, Byte midiNote) {
        this.releaseNote(midiNote);
    }

    private void allNotesOff() {
        if (this.heldNotes != null && this.instrumentId != null) {
            ArrayList notesToRemove = new ArrayList(this.heldNotes.keySet());
            for (Byte note : notesToRemove) {
                this.releaseNote(note);
            }
            MidiNotePacket packet = new MidiNotePacket(MidiNotePacket.ALL_NOTES_OFF, Integer.valueOf(0).byteValue(), this.instrumentId, this.player.func_110124_au(), false, this.player.func_233580_cy_());
            NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
            MIMIMod.proxy.getMidiSynth().handlePacket(packet);
        }
    }

    private void onGuiNotePress(Byte midiNote, Byte velocity) {
        MidiNotePacket packet = new MidiNotePacket(midiNote, ItemMidiSwitchboard.applyVolume(this.selectedSwitchboardStack, velocity), this.instrumentId, this.player.func_110124_au(), false, this.player.func_233580_cy_());
        NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
        DebugUtils.logNoteTimingInfo(((Object)((Object)this)).getClass(), true, this.instrumentId, midiNote, velocity, this.player.func_233580_cy_());
        MIMIMod.proxy.getMidiSynth().handlePacket(packet);
        this.onMidiNoteOn(null, midiNote, velocity);
    }

    private void onGuiNoteRelease(Byte midiNote) {
        MidiNotePacket packet = new MidiNotePacket(midiNote, Integer.valueOf(0).byteValue(), this.instrumentId, this.player.func_110124_au(), false, this.player.func_233580_cy_());
        NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
        DebugUtils.logNoteTimingInfo(((Object)((Object)this)).getClass(), false, this.instrumentId, midiNote, null, null);
        MIMIMod.proxy.getMidiSynth().handlePacket(packet);
        this.onMidiNoteOff(null, midiNote);
    }

    private void holdNote(Byte midiNote, Byte velocity) {
        this.releasedNotes.remove(midiNote);
        this.heldNotes.put(midiNote, Instant.now());
    }

    private void releaseNote(Byte midiNote) {
        if (this.heldNotes.remove(midiNote) != null) {
            this.releasedNotes.put(midiNote, Instant.now());
        }
    }

    private Set<Byte> getMidiNoteFromScanCode(Integer scanCode, Boolean modifier, Boolean ignoreModifier) {
        switch ((ClientConfig.KEYBOARD_LAYOUTS)((Object)ModConfigs.CLIENT.keyboardLayout.get())) {
            case MIMI: {
                return Arrays.asList(this.getMidiNoteFromScanCode_MIMI(scanCode)).stream().filter(b -> b != null).collect(Collectors.toSet());
            }
            case VPiano: {
                return Arrays.asList(this.getMidiNoteFromScanCode_VPiano(scanCode, modifier), ignoreModifier != false ? this.getMidiNoteFromScanCode_VPiano(scanCode, modifier == false) : null).stream().filter(b -> b != null).collect(Collectors.toSet());
            }
        }
        MIMIMod.LOGGER.info("Warning: Unknown keyboard layout selected for Instrument GUI.");
        return null;
    }

    private Byte getMidiNoteFromScanCode_MIMI(Integer scanCode) {
        Integer keyNum = null;
        if (scanCode >= this.ACCENT_LEFT_MIN_SCAN && scanCode <= this.ACCENT_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.ACCENT_LEFT_MIN_SCAN + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.NOTE_LEFT_MIN_SCAN && scanCode <= this.NOTE_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.NOTE_LEFT_MIN_SCAN + 1;
            keyNum = keyNum + (keyNum - 1);
        } else if (scanCode >= this.ACCENT_RIGHT_MIN_SCAN && scanCode <= this.ACCENT_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.ACCENT_RIGHT_MIN_SCAN + (this.ACCENT_LEFT_MAX_SCAN - this.ACCENT_LEFT_MIN_SCAN) + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.NOTE_RIGHT_MIN_SCAN && scanCode <= this.NOTE_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.NOTE_RIGHT_MIN_SCAN + (this.NOTE_LEFT_MAX_SCAN - this.NOTE_LEFT_MIN_SCAN) + 2;
            keyNum = keyNum + (keyNum - 1);
        }
        if (keyNum != null) {
            Byte result = this.keyNumToMidiNote(keyNum);
            return result;
        }
        return null;
    }

    private Byte getMidiNoteFromScanCode_VPiano(Integer scanCode, Boolean modifier) {
        Integer midiInt = this.VPianoMidiMap.get(scanCode * (modifier != false ? -1 : 1));
        return midiInt != null ? Byte.valueOf(new Integer(24 + midiInt).byteValue()) : null;
    }

    @Override
    protected MatrixStack renderGraphics(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Integer widthShift;
        this.setAlpha(1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.guiTexture);
        Integer keyboardTextureShift = this.visibleNoteShift % (NOTE_WIDTH / 2) * NOTE_WIDTH;
        GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1), (int)(this.field_147009_r + NOTE_OFFSET_Y - 1), (int)this.func_230927_p_(), (float)keyboardTextureShift.intValue(), (float)276.0f, (int)308, (int)128, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        if (ClientConfig.KEYBOARD_LAYOUTS.MIMI.equals(ModConfigs.CLIENT.keyboardLayout.get())) {
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1), (int)(this.field_147009_r + NOTE_OFFSET_Y + 70), (int)this.func_230927_p_(), (float)0.0f, (float)457.0f, (int)308, (int)53, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        } else if (this.visibleNoteShift < this.V_PIANO_MIN_SHIFT) {
            widthShift = (this.V_PIANO_MIN_SHIFT - this.visibleNoteShift) * NOTE_WIDTH;
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1 + widthShift), (int)(this.field_147009_r + NOTE_OFFSET_Y + 70), (int)this.func_230927_p_(), (float)0.0f, (float)404.0f, (int)(308 - widthShift), (int)53, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        } else if (this.visibleNoteShift >= this.V_PIANO_MIN_SHIFT && this.visibleNoteShift <= this.V_PIANO_MAX_SHIFT) {
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1), (int)(this.field_147009_r + NOTE_OFFSET_Y + 70), (int)this.func_230927_p_(), (float)((this.visibleNoteShift - this.V_PIANO_MIN_SHIFT) * NOTE_WIDTH), (float)404.0f, (int)308, (int)53, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        } else if (this.visibleNoteShift <= this.V_PIANO_MAX_NOTE) {
            widthShift = (this.V_PIANO_MAX_SHIFT - this.visibleNoteShift) * -NOTE_WIDTH.intValue();
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1), (int)(this.field_147009_r + NOTE_OFFSET_Y + 70), (int)this.func_230927_p_(), (float)((this.visibleNoteShift - this.V_PIANO_MIN_SHIFT) * NOTE_WIDTH), (float)404.0f, (int)(308 - widthShift), (int)53, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (this.visibleNoteShift == 0) {
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X), (int)(this.field_147009_r + NOTE_OFFSET_Y), (int)this.func_230927_p_(), (float)392.0f, (float)276.0f, (int)6, (int)86, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        } else if (this.visibleNoteShift == MAX_NOTE_SHIFT) {
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 311), (int)(this.field_147009_r + NOTE_OFFSET_Y), (int)this.func_230927_p_(), (float)392.0f, (float)276.0f, (int)6, (int)86, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        matrixStack = this.renderAndCleanNoteSet(matrixStack, this.heldNotes, 5000, true, entry -> this.onGuiNoteRelease((Byte)entry.getKey()));
        matrixStack = this.renderAndCleanNoteSet(matrixStack, this.releasedNotes, 1000, false, entry -> this.releasedNotes.remove(entry.getKey()));
        this.setAlpha(1.0f);
        GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X - 1), (int)(this.field_147009_r + NOTE_OFFSET_Y + 55), (int)this.func_230927_p_(), (float)keyboardTextureShift.intValue(), (float)250.0f, (int)308, (int)26, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        if (this.editMode.booleanValue()) {
            SortedArraySet<Byte> acceptedChannels;
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true));
            GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(-(this.field_147009_r + 29 + 126)), (int)(this.field_147003_i + 11), (int)this.func_230927_p_(), (float)404.0f, (float)0.0f, (int)126, (int)306, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            matrixStack.func_227865_b_();
            if (ItemMidiSwitchboard.getSysInput(this.selectedSwitchboardStack).booleanValue()) {
                GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 124), (int)(this.field_147009_r + 90), (int)this.func_230927_p_(), (float)329.0f, (float)42.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            }
            if ((acceptedChannels = ItemMidiSwitchboard.getEnabledChannelsSet(this.selectedSwitchboardStack)) != null && !acceptedChannels.isEmpty()) {
                for (Byte channelId : acceptedChannels) {
                    GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 166 + 19 * (channelId % 8)), (int)(this.field_147009_r + 119 + channelId / 8 * 25), (int)this.func_230927_p_(), (float)329.0f, (float)42.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
                }
            }
        }
        return matrixStack;
    }

    private MatrixStack renderAndCleanNoteSet(MatrixStack matrixStack, ConcurrentHashMap<Byte, Instant> noteMap, Integer sustainMillis, Boolean held, Consumer<Map.Entry<Byte, Instant>> removeHandler) {
        ArrayList<Map.Entry<Byte, Instant>> notesToRemove = new ArrayList<Map.Entry<Byte, Instant>>();
        if (!noteMap.isEmpty()) {
            for (Map.Entry<Byte, Instant> entry2 : noteMap.entrySet()) {
                if (Math.abs(ChronoUnit.MILLIS.between(Instant.now(), entry2.getValue())) > (long)sustainMillis.intValue()) {
                    notesToRemove.add(entry2);
                }
                matrixStack = this.renderNote(matrixStack, entry2.getKey(), held, entry2.getValue());
            }
            notesToRemove.forEach(entry -> removeHandler.accept((Map.Entry<Byte, Instant>)entry));
        }
        return matrixStack;
    }

    private MatrixStack renderNote(MatrixStack matrixStack, Byte note, Boolean held, Instant releaseTime) {
        Float alpha = Float.valueOf(1.0f);
        Integer keyNum = this.midiNoteToKeyNum(note);
        if (keyNum == null) {
            return matrixStack;
        }
        if (!held.booleanValue()) {
            alpha = Float.valueOf(alpha.floatValue() - Math.min((float)Math.abs(ChronoUnit.MILLIS.between(Instant.now(), releaseTime)) / 1000.0f, 1.0f));
        }
        this.setAlpha(alpha.floatValue());
        GuiInstrumentContainerScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + NOTE_OFFSET_X + (keyNum - 1) * NOTE_WIDTH / 2), (int)(this.field_147009_r + NOTE_OFFSET_Y + 43 + keyNum % 2 * 42), (int)this.func_230927_p_(), (float)(342 - keyNum % 2 * 13), (float)0.0f, (int)12, (int)41, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        return matrixStack;
    }

    @Override
    protected MatrixStack renderText(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.instrumentNameString, 198.0f, 13.0f, -16718336);
        this.field_230712_o_.func_238421_b_(matrixStack, this.noteIdString.split(",")[0], 22.0f, 197.0f, -16718336);
        this.field_230712_o_.func_238421_b_(matrixStack, this.noteIdString.split(",")[1], 67.0f, 197.0f, -16718336);
        this.field_230712_o_.func_238421_b_(matrixStack, this.noteIdString.split(",")[2], 126.0f, 197.0f, -16718336);
        if (this.editMode.booleanValue()) {
            String selectedSourceName = ItemMidiSwitchboard.getMidiSourceName(this.selectedSwitchboardStack);
            this.field_230712_o_.func_238421_b_(matrixStack, selectedSourceName.length() <= 22 ? selectedSourceName : selectedSourceName.substring(0, 21) + "...", 21.0f, 122.0f, -16718336);
            this.field_230712_o_.func_238421_b_(matrixStack, ItemMidiSwitchboard.getInstrumentVolumePercent(this.selectedSwitchboardStack).toString(), 180.0f, 62.0f, -16718336);
        }
        if (this.editMode.booleanValue()) {
            this.field_230712_o_.func_238421_b_(matrixStack, ((ClientConfig.KEYBOARD_LAYOUTS)((Object)ModConfigs.CLIENT.keyboardLayout.get())).toString(), 264.0f, 35.0f, -16763392);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, ((ClientConfig.KEYBOARD_LAYOUTS)((Object)ModConfigs.CLIENT.keyboardLayout.get())).toString(), 264.0f, 35.0f, -16718336);
        }
        return matrixStack;
    }

    private String buildNoteIdString() {
        String result = "";
        result = result + this.noteLetterFromNum(this.visibleNoteShift % 7) + new Integer(this.visibleNoteShift / 7).toString();
        result = result + "," + this.noteLetterFromNum((this.visibleNoteShift + 10) % 7) + new Integer((this.visibleNoteShift + 10) / 7).toString();
        result = result + " | " + this.noteLetterFromNum((this.visibleNoteShift + 11) % 7) + new Integer((this.visibleNoteShift + 11) / 7).toString();
        result = result + "," + this.noteLetterFromNum((this.visibleNoteShift + 21) % 7) + new Integer((this.visibleNoteShift + 21) / 7).toString();
        return result;
    }

    private String noteLetterFromNum(Integer octaveNoteNum) {
        switch (octaveNoteNum) {
            case 0: {
                return "C";
            }
            case 1: {
                return "D";
            }
            case 2: {
                return "E";
            }
            case 3: {
                return "F";
            }
            case 4: {
                return "G";
            }
            case 5: {
                return "A";
            }
            case 6: {
                return "B";
            }
        }
        return "";
    }

    public void syncInstrumentToServer() {
        SyncItemInstrumentSwitchboardPacket packet = new SyncItemInstrumentSwitchboardPacket(true);
        if (packet != null) {
            NetworkManager.NET_CHANNEL.sendToServer((Object)packet);
        }
    }
}

