/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseContainerGui<T extends Container>
extends ContainerScreen<T> {
    protected static final Integer STANDARD_BUTTON_SIZE = 15;
    protected ResourceLocation guiTexture;
    protected Integer TEXTURE_SIZE;

    public BaseContainerGui(T container, PlayerInventory inv, Integer width, Integer height, Integer textureSize, String textureResource, ITextComponent textComponent) {
        super(container, inv, textComponent);
        this.guiTexture = new ResourceLocation("mimi", textureResource);
        this.TEXTURE_SIZE = textureSize;
        this.field_230711_n_ = false;
        this.field_147000_g = height;
        this.field_146999_f = width;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        matrixStack = this.renderGraphics(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        matrixStack = this.renderText(matrixStack, mouseX, mouseY);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldRenderBackground().booleanValue()) {
            this.func_230446_a_(matrixStack);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected Boolean shouldRenderBackground() {
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input invKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        return !this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(invKey) && super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    protected void setAlpha(float alpha) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    protected abstract MatrixStack renderGraphics(MatrixStack var1, int var2, int var3, float var4);

    protected abstract MatrixStack renderText(MatrixStack var1, int var2, int var3);

    protected Boolean clickedBox(Integer mouseX, Integer mouseY, Vector2f buttonPos) {
        Integer buttonMinX = this.field_147003_i + new Float(buttonPos.field_189982_i).intValue();
        Integer buttonMaxX = buttonMinX + STANDARD_BUTTON_SIZE;
        Integer buttonMinY = this.field_147009_r + new Float(buttonPos.field_189983_j).intValue();
        Integer buttonMaxY = buttonMinY + STANDARD_BUTTON_SIZE;
        Boolean result = mouseX >= buttonMinX && mouseX <= buttonMaxX && mouseY >= buttonMinY && mouseY <= buttonMaxY;
        if (result.booleanValue()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        return result;
    }
}

