/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseContainerGui;
import io.github.tofodroid.mods.mimi.common.container.ASwitchboardContainer;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.network.NetworkManager;
import io.github.tofodroid.mods.mimi.common.network.SwitchboardStackUpdatePacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class ASwitchboardGui<T extends ASwitchboardContainer>
extends BaseContainerGui<T> {
    protected final PlayerEntity player;
    protected ItemStack selectedSwitchboardStack;

    public ASwitchboardGui(T container, PlayerInventory inv, Integer width, Integer height, Integer textureSize, String textureResource, ITextComponent textComponent) {
        super(container, inv, width, height, textureSize, textureResource, textComponent);
        this.player = inv.field_70458_d;
        if (((Object)((Object)ModItems.SWITCHBOARD)).equals(container.func_75139_a(36).func_75211_c().func_77973_b())) {
            this.selectedSwitchboardStack = container.func_75139_a(36).func_75211_c();
            this.loadSelectedSwitchboard();
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.selectedSwitchboardStack == null && ((ASwitchboardContainer)this.field_147002_h).func_75139_a(36).func_75211_c().func_190926_b()) {
            return;
        }
        if (this.selectedSwitchboardStack != ((ASwitchboardContainer)this.field_147002_h).func_75139_a(36).func_75211_c()) {
            this.selectedSwitchboardStack = !((Object)((Object)ModItems.SWITCHBOARD)).equals(((ASwitchboardContainer)this.field_147002_h).func_75139_a(36).func_75211_c().func_77973_b()) ? null : ((ASwitchboardContainer)this.field_147002_h).func_75139_a(36).func_75211_c();
            this.onSelectedSwitchboardChange();
        }
    }

    protected Boolean onSelectedSwitchboardChange() {
        if (this.selectedSwitchboardStack != null) {
            this.loadSelectedSwitchboard();
            return true;
        }
        this.clearSwitchboard();
        return false;
    }

    protected void loadSelectedSwitchboard() {
    }

    protected void clearSwitchboard() {
    }

    protected void syncSwitchboardToServer() {
        SwitchboardStackUpdatePacket packet = null;
        if (this.selectedSwitchboardStack != null && ((Object)((Object)ModItems.SWITCHBOARD)).equals(this.selectedSwitchboardStack.func_77973_b())) {
            packet = ItemMidiSwitchboard.getSyncPacket(this.selectedSwitchboardStack);
        }
        if (packet != null) {
            NetworkManager.NET_CHANNEL.sendToServer(packet);
        }
    }

    protected void setSelfSource() {
        ItemMidiSwitchboard.setMidiSource(this.selectedSwitchboardStack, this.player.func_110124_au(), this.player.func_200200_C_().getString());
        this.syncSwitchboardToServer();
    }

    protected void setPublicSource() {
        ItemMidiSwitchboard.setMidiSource(this.selectedSwitchboardStack, ItemMidiSwitchboard.PUBLIC_SOURCE_ID, "Public");
        this.syncSwitchboardToServer();
    }

    protected void clearSource() {
        ItemMidiSwitchboard.setMidiSource(this.selectedSwitchboardStack, null, "None");
        this.syncSwitchboardToServer();
    }

    protected void enableAllChannels() {
        ItemMidiSwitchboard.setEnableAllChannels(this.selectedSwitchboardStack);
        this.syncSwitchboardToServer();
    }

    protected void clearChannels() {
        ItemMidiSwitchboard.clearEnabledChannels(this.selectedSwitchboardStack);
        this.syncSwitchboardToServer();
    }

    protected void toggleChannel(Integer channelId) {
        ItemMidiSwitchboard.toggleChannel(this.selectedSwitchboardStack, new Integer(channelId).byteValue());
        this.syncSwitchboardToServer();
    }

    protected void changeVolume(Integer changeAmount) {
        ItemMidiSwitchboard.setInstrumentVolume(this.selectedSwitchboardStack, new Integer(ItemMidiSwitchboard.getInstrumentVolume(this.selectedSwitchboardStack) + changeAmount).byteValue());
        this.syncSwitchboardToServer();
    }
}

