/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.tofodroid.mods.mimi.client.gui.ASwitchboardGui;
import io.github.tofodroid.mods.mimi.common.container.ASwitchboardContainer;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;

public abstract class ASwitchboardBlockGui<T extends ASwitchboardContainer>
extends ASwitchboardGui<T> {
    protected static final Vector2f ALL_MIDI_BUTTON_COORDS = new Vector2f(16.0f, 48.0f);
    protected static final Vector2f GEN_MIDI_BUTTON_COORDS = new Vector2f(35.0f, 48.0f);
    protected static final Vector2f CLEAR_MIDI_BUTTON_COORDS = new Vector2f(16.0f, 73.0f);
    protected static final Vector2f FILTER_NOTE_OCTAVE_BUTTON_COORDS = new Vector2f(211.0f, 48.0f);
    protected static final Vector2f FILTER_NOTE_LETTER_BUTTON_COORDS = new Vector2f(192.0f, 48.0f);
    protected static final Vector2f FILTER_NOTE_INVERT_BUTTON_COORDS = new Vector2f(275.0f, 48.0f);
    protected static final Vector2f FILTER_INSTRUMENT_PREV_BUTTON_COORDS = new Vector2f(16.0f, 113.0f);
    protected static final Vector2f FILTER_INSTRUMENT_NEXT_BUTTON_COORDS = new Vector2f(150.0f, 113.0f);
    protected static final Vector2f FILTER_INSTRUMENT_INVERT_BUTTON_COORDS = new Vector2f(168.0f, 113.0f);
    protected static final Vector2f TRANSMIT_SELF_BUTTON_COORDS = new Vector2f(218.0f, 97.0f);
    protected static final Vector2f TRANSMIT_PUBLIC_BUTTON_COORDS = new Vector2f(237.0f, 97.0f);
    protected static final Vector2f TRANSMIT_CLEAR_BUTTON_COORDS = new Vector2f(256.0f, 97.0f);
    protected static final Vector2f BROADCAST_MODE_BUTTON_COORDS = new Vector2f(143.0f, 135.0f);
    protected static final Vector2f BROADCAST_NOTE_OCTAVE_BUTTON_COORDS = new Vector2f(211.0f, 134.0f);
    protected static final Vector2f BROADCAST_NOTE_LETTER_BUTTON_COORDS = new Vector2f(192.0f, 134.0f);
    protected static final Vector2f INSTRUMENT_VOLUME_UP_BUTTON_COORDS = new Vector2f(306.0f, 74.0f);
    protected static final Vector2f INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS = new Vector2f(306.0f, 110.0f);
    protected static final Vector2f FILTER_NOTE_TEXTBOX_COORDS = new Vector2f(232.0f, 52.0f);
    protected static final Vector2f FILTER_INSTRUMENT_TEXTBOX_COORDS = new Vector2f(35.0f, 117.0f);
    protected static final Vector2f LINKED_TRANSMITTER_TEXTBOX_COORDS = new Vector2f(194.0f, 85.0f);
    protected static final Vector2f BROADCAST_NOTE_TEXTBOX_COORDS = new Vector2f(232.0f, 138.0f);
    protected static final Vector2f INSTRUMENT_VOLUME_TEXTBOX_COORDS = new Vector2f(308.0f, 96.0f);
    protected static final Vector2f MIDI_STATUSBOX_COORDS = new Vector2f(41.0f, 66.0f);
    protected static final Vector2f FILTER_NOTE_STATUSBOX_COORDS = new Vector2f(294.0f, 54.0f);
    protected static final Vector2f FILTER_INSTRUMENT_STATUSBOX_COORDS = new Vector2f(174.0f, 107.0f);
    protected static final Vector2f BROADCAST_MODE_STATUSBOX_COORDS = new Vector2f(161.0f, 136.0f);
    protected List<Byte> INSTRUMENT_ID_LIST;
    protected Integer filterInstrumentIndex = 0;
    protected Integer filterNoteOctave;
    protected Integer filterNoteLetter;
    protected String filterNoteString = "";

    public ASwitchboardBlockGui(T container, PlayerInventory inv, ITextComponent textComponent) {
        super(container, inv, 337, 250, 395, "textures/gui/container_generic_switchboard_block.png", textComponent);
    }

    @Override
    public void loadSelectedSwitchboard() {
        super.loadSelectedSwitchboard();
        this.loadFilterLetterAndOctave();
        this.filterInstrumentIndex = this.INSTRUMENT_ID_LIST().indexOf(ItemMidiSwitchboard.getInstrument(this.selectedSwitchboardStack));
    }

    @Override
    public void clearSwitchboard() {
        super.clearSwitchboard();
        this.filterNoteLetter = 127;
        this.filterNoteOctave = 127;
        this.filterNoteString = "";
        this.filterInstrumentIndex = null;
    }

    public boolean func_231044_a_(double dmouseX, double dmouseY, int button) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (this.selectedSwitchboardStack != null) {
            if (this.noteFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_NOTE_OCTAVE_BUTTON_COORDS).booleanValue()) {
                this.shiftFilterNoteOctave();
            } else if (this.noteFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_NOTE_LETTER_BUTTON_COORDS).booleanValue()) {
                this.shiftFilterNoteLetter();
            } else if (this.noteFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_NOTE_INVERT_BUTTON_COORDS).booleanValue()) {
                this.toggleInvertFilterNote();
            } else if (this.linkedTransmitterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, TRANSMIT_SELF_BUTTON_COORDS).booleanValue()) {
                this.setSelfSource();
            } else if (this.linkedTransmitterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, TRANSMIT_PUBLIC_BUTTON_COORDS).booleanValue()) {
                this.setPublicSource();
            } else if (this.linkedTransmitterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, TRANSMIT_CLEAR_BUTTON_COORDS).booleanValue()) {
                this.clearSource();
            } else if (this.instrumentFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_INSTRUMENT_PREV_BUTTON_COORDS).booleanValue()) {
                this.shiftInstrumentId(false);
            } else if (this.instrumentFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_INSTRUMENT_NEXT_BUTTON_COORDS).booleanValue()) {
                this.shiftInstrumentId(true);
            } else if (this.instrumentFilterWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, FILTER_INSTRUMENT_INVERT_BUTTON_COORDS).booleanValue()) {
                ItemMidiSwitchboard.setInvertInstrument(this.selectedSwitchboardStack, ItemMidiSwitchboard.getInvertInstrument(this.selectedSwitchboardStack) == false);
                this.syncSwitchboardToServer();
            } else if (this.broadcastNoteWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, BROADCAST_NOTE_OCTAVE_BUTTON_COORDS).booleanValue()) {
                this.shiftBroadcastNoteOctave();
            } else if (this.broadcastNoteWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, BROADCAST_NOTE_LETTER_BUTTON_COORDS).booleanValue()) {
                this.shiftBroadcastNoteLetter();
            } else if (this.broadcastModeWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, BROADCAST_MODE_BUTTON_COORDS).booleanValue()) {
                ItemMidiSwitchboard.setPublicBroadcast(this.selectedSwitchboardStack, ItemMidiSwitchboard.getPublicBroadcast(this.selectedSwitchboardStack) == false);
                this.syncSwitchboardToServer();
            } else if (this.instrumentVolumeWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, INSTRUMENT_VOLUME_UP_BUTTON_COORDS).booleanValue()) {
                this.changeVolume(1);
            } else if (this.instrumentVolumeWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS).booleanValue()) {
                this.changeVolume(-1);
            } else if (this.channelWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, CLEAR_MIDI_BUTTON_COORDS).booleanValue()) {
                this.clearChannels();
            } else if (this.channelWidgetEnabled().booleanValue() && this.clickedBox(imouseX, imouseY, ALL_MIDI_BUTTON_COORDS).booleanValue()) {
                this.enableAllChannels();
            } else if (this.channelWidgetEnabled().booleanValue()) {
                for (int i = 0; i < 16; ++i) {
                    Vector2f buttonCoords = new Vector2f(ASwitchboardBlockGui.GEN_MIDI_BUTTON_COORDS.field_189982_i + (float)(i % 8 * 19), ASwitchboardBlockGui.GEN_MIDI_BUTTON_COORDS.field_189983_j + (float)(i / 8 * 27));
                    if (!this.clickedBox(imouseX, imouseY, buttonCoords).booleanValue()) continue;
                    this.toggleChannel(i);
                    return super.func_231044_a_(dmouseX, dmouseY, button);
                }
            }
        }
        return super.func_231044_a_(dmouseX, dmouseY, button);
    }

    @Override
    protected MatrixStack renderGraphics(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.guiTexture);
        ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(this.titleBoxPos().field_189982_i).intValue()), (int)(this.field_147009_r + new Float(this.titleBoxPos().field_189983_j).intValue()), (int)this.func_230927_p_(), (float)new Float(this.titleBoxBlit().field_189982_i).intValue(), (float)new Float(this.titleBoxBlit().field_189983_j).intValue(), (int)new Float(this.titleBoxSize().field_189982_i).intValue(), (int)new Float(this.titleBoxSize().field_189983_j).intValue(), (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(this.switchboardSlotPos().field_189982_i).intValue()), (int)(this.field_147009_r + new Float(this.switchboardSlotPos().field_189983_j).intValue()), (int)this.func_230927_p_(), (float)143.0f, (float)367.0f, (int)140, (int)28, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        if (this.selectedSwitchboardStack != null) {
            SortedArraySet<Byte> acceptedChannels = ItemMidiSwitchboard.getEnabledChannelsSet(this.selectedSwitchboardStack);
            if (acceptedChannels != null && !acceptedChannels.isEmpty()) {
                for (Byte channelId : acceptedChannels) {
                    ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(ASwitchboardBlockGui.MIDI_STATUSBOX_COORDS.field_189982_i).intValue() + 19 * (channelId % 8)), (int)(this.field_147009_r + new Float(ASwitchboardBlockGui.MIDI_STATUSBOX_COORDS.field_189983_j).intValue() + channelId / 8 * 25), (int)this.func_230927_p_(), (float)213.0f, (float)281.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
                }
            }
            if (ItemMidiSwitchboard.getPublicBroadcast(this.selectedSwitchboardStack).booleanValue()) {
                ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(ASwitchboardBlockGui.BROADCAST_MODE_STATUSBOX_COORDS.field_189982_i).intValue()), (int)(this.field_147009_r + new Float(ASwitchboardBlockGui.BROADCAST_MODE_STATUSBOX_COORDS.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)173.0f, (float)281.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            } else {
                ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(ASwitchboardBlockGui.BROADCAST_MODE_STATUSBOX_COORDS.field_189982_i).intValue()), (int)(this.field_147009_r + new Float(ASwitchboardBlockGui.BROADCAST_MODE_STATUSBOX_COORDS.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)186.0f, (float)281.0f, (int)13, (int)13, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            }
            if (ItemMidiSwitchboard.getInvertNoteOct(this.selectedSwitchboardStack).booleanValue()) {
                ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(ASwitchboardBlockGui.FILTER_NOTE_STATUSBOX_COORDS.field_189982_i).intValue()), (int)(this.field_147009_r + new Float(ASwitchboardBlockGui.FILTER_NOTE_STATUSBOX_COORDS.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)213.0f, (float)281.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            }
            if (ItemMidiSwitchboard.getInvertInstrument(this.selectedSwitchboardStack).booleanValue()) {
                ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + new Float(ASwitchboardBlockGui.FILTER_INSTRUMENT_STATUSBOX_COORDS.field_189982_i).intValue()), (int)(this.field_147009_r + new Float(ASwitchboardBlockGui.FILTER_INSTRUMENT_STATUSBOX_COORDS.field_189983_j).intValue()), (int)this.func_230927_p_(), (float)213.0f, (float)281.0f, (int)3, (int)3, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
            }
        }
        if (!this.channelWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 14), (int)(this.field_147009_r + 32), (int)this.func_230927_p_(), (float)1.0f, (float)281.0f, (int)171, (int)65, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.noteFilterWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 189), (int)(this.field_147009_r + 32), (int)this.func_230927_p_(), (float)237.0f, (float)254.0f, (int)111, (int)34, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.instrumentFilterWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 14), (int)(this.field_147009_r + 100), (int)this.func_230927_p_(), (float)177.0f, (float)336.0f, (int)171, (int)30, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.linkedTransmitterWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 189), (int)(this.field_147009_r + 69), (int)this.func_230927_p_(), (float)237.0f, (float)289.0f, (int)111, (int)46, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.broadcastModeWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 14), (int)(this.field_147009_r + 133), (int)this.func_230927_p_(), (float)1.0f, (float)347.0f, (int)171, (int)19, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.broadcastNoteWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 189), (int)(this.field_147009_r + 118), (int)this.func_230927_p_(), (float)237.0f, (float)254.0f, (int)111, (int)34, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        if (!this.instrumentVolumeWidgetEnabled().booleanValue()) {
            ASwitchboardBlockGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 304), (int)(this.field_147009_r + 58), (int)this.func_230927_p_(), (float)217.0f, (float)266.0f, (int)19, (int)69, (int)this.TEXTURE_SIZE, (int)this.TEXTURE_SIZE);
        }
        return matrixStack;
    }

    @Override
    protected MatrixStack renderText(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.selectedSwitchboardStack != null) {
            String selectedSourceName = ItemMidiSwitchboard.getMidiSourceName(this.selectedSwitchboardStack);
            this.field_230712_o_.func_238421_b_(matrixStack, selectedSourceName.length() <= 22 ? selectedSourceName : selectedSourceName.substring(0, 21) + "...", (float)new Float(ASwitchboardBlockGui.LINKED_TRANSMITTER_TEXTBOX_COORDS.field_189982_i).intValue(), (float)new Float(ASwitchboardBlockGui.LINKED_TRANSMITTER_TEXTBOX_COORDS.field_189983_j).intValue(), this.linkedTransmitterWidgetEnabled() != false ? -16718336 : -16753664);
            this.field_230712_o_.func_238421_b_(matrixStack, this.filterNoteString, (float)new Float(ASwitchboardBlockGui.FILTER_NOTE_TEXTBOX_COORDS.field_189982_i).intValue(), (float)new Float(ASwitchboardBlockGui.FILTER_NOTE_TEXTBOX_COORDS.field_189983_j).intValue(), this.noteFilterWidgetEnabled() != false ? -16718336 : -16753664);
            this.field_230712_o_.func_238421_b_(matrixStack, ModItems.SWITCHBOARD.getInstrumentName(this.selectedSwitchboardStack), (float)new Float(ASwitchboardBlockGui.FILTER_INSTRUMENT_TEXTBOX_COORDS.field_189982_i).intValue(), (float)new Float(ASwitchboardBlockGui.FILTER_INSTRUMENT_TEXTBOX_COORDS.field_189983_j).intValue(), this.instrumentFilterWidgetEnabled() != false ? -16718336 : -16753664);
            this.field_230712_o_.func_238421_b_(matrixStack, ItemMidiSwitchboard.getBroadcastNoteAsString(this.selectedSwitchboardStack), (float)new Float(ASwitchboardBlockGui.BROADCAST_NOTE_TEXTBOX_COORDS.field_189982_i).intValue(), (float)new Float(ASwitchboardBlockGui.BROADCAST_NOTE_TEXTBOX_COORDS.field_189983_j).intValue(), this.broadcastNoteWidgetEnabled() != false ? -16718336 : -16753664);
            this.field_230712_o_.func_238421_b_(matrixStack, ItemMidiSwitchboard.getInstrumentVolumePercent(this.selectedSwitchboardStack).toString(), (float)new Float(ASwitchboardBlockGui.INSTRUMENT_VOLUME_TEXTBOX_COORDS.field_189982_i).intValue(), (float)new Float(ASwitchboardBlockGui.INSTRUMENT_VOLUME_TEXTBOX_COORDS.field_189983_j).intValue(), this.instrumentVolumeWidgetEnabled() != false ? -16718336 : -16753664);
        }
        return matrixStack;
    }

    public List<Byte> INSTRUMENT_ID_LIST() {
        if (this.INSTRUMENT_ID_LIST == null) {
            this.INSTRUMENT_ID_LIST = ModItems.SWITCHBOARD.INSTRUMENT_NAME_MAP().keySet().stream().sorted().collect(Collectors.toList());
        }
        return this.INSTRUMENT_ID_LIST;
    }

    public void shiftInstrumentId(Boolean up) {
        if (up.booleanValue()) {
            if (this.filterInstrumentIndex < this.INSTRUMENT_ID_LIST.size() - 1) {
                Integer n = this.filterInstrumentIndex;
                Integer n2 = this.filterInstrumentIndex = Integer.valueOf(this.filterInstrumentIndex + 1);
            } else {
                this.filterInstrumentIndex = 0;
            }
        } else if (this.filterInstrumentIndex > 0) {
            Integer n = this.filterInstrumentIndex;
            Integer n3 = this.filterInstrumentIndex = Integer.valueOf(this.filterInstrumentIndex - 1);
        } else {
            this.filterInstrumentIndex = this.INSTRUMENT_ID_LIST.size() - 1;
        }
        ItemMidiSwitchboard.setInstrument(this.selectedSwitchboardStack, this.INSTRUMENT_ID_LIST.get(this.filterInstrumentIndex));
        this.syncSwitchboardToServer();
    }

    protected void shiftBroadcastNoteLetter() {
        Byte broadcastNote = ItemMidiSwitchboard.getBroadcastNote(this.selectedSwitchboardStack);
        if (broadcastNote % 12 < 11) {
            if (broadcastNote + 1 <= 127) {
                Byte by = broadcastNote;
                Byte by2 = broadcastNote = Byte.valueOf((byte)(broadcastNote + 1));
            } else {
                broadcastNote = new Integer(broadcastNote - broadcastNote % 12).byteValue();
            }
        } else {
            broadcastNote = new Integer(broadcastNote - 11).byteValue();
        }
        ItemMidiSwitchboard.setBroadcastNote(this.selectedSwitchboardStack, broadcastNote);
        this.syncSwitchboardToServer();
    }

    protected void shiftBroadcastNoteOctave() {
        Byte broadcastNote = ItemMidiSwitchboard.getBroadcastNote(this.selectedSwitchboardStack);
        broadcastNote = broadcastNote / 12 < 10 ? (broadcastNote + 12 <= 127 ? Byte.valueOf(new Integer(broadcastNote + 12).byteValue()) : Byte.valueOf(new Integer(broadcastNote + -108).byteValue())) : Byte.valueOf(new Integer(broadcastNote - 120).byteValue());
        ItemMidiSwitchboard.setBroadcastNote(this.selectedSwitchboardStack, broadcastNote);
        this.syncSwitchboardToServer();
    }

    protected void shiftFilterNoteLetter() {
        if (this.filterNoteLetter < 11) {
            Integer n = this.filterNoteLetter;
            Integer n2 = this.filterNoteLetter = Integer.valueOf(this.filterNoteLetter + 1);
            if (this.invalidFilterNote().booleanValue()) {
                this.filterNoteLetter = -1;
            }
        } else {
            this.filterNoteLetter = -1;
        }
        ItemMidiSwitchboard.setFilterNote(this.selectedSwitchboardStack, this.filterNoteLetter.byteValue());
        this.filterNoteString = ItemMidiSwitchboard.getFilteredNotesAsString(this.selectedSwitchboardStack);
        this.syncSwitchboardToServer();
    }

    protected void shiftFilterNoteOctave() {
        if (this.filterNoteOctave < 10) {
            Integer n = this.filterNoteOctave;
            Integer n2 = this.filterNoteOctave = Integer.valueOf(this.filterNoteOctave + 1);
            if (this.invalidFilterNote().booleanValue()) {
                this.filterNoteOctave = -1;
            }
        } else {
            this.filterNoteOctave = -1;
        }
        ItemMidiSwitchboard.setFilterOct(this.selectedSwitchboardStack, this.filterNoteOctave.byteValue());
        this.filterNoteString = ItemMidiSwitchboard.getFilteredNotesAsString(this.selectedSwitchboardStack);
        this.syncSwitchboardToServer();
    }

    protected void toggleInvertFilterNote() {
        ItemMidiSwitchboard.setInvertNoteOct(this.selectedSwitchboardStack, ItemMidiSwitchboard.getInvertNoteOct(this.selectedSwitchboardStack) == false);
        this.filterNoteString = ItemMidiSwitchboard.getFilteredNotesAsString(this.selectedSwitchboardStack);
        this.syncSwitchboardToServer();
    }

    protected Boolean invalidFilterNote() {
        return new Integer(this.filterNoteOctave * 12 + this.filterNoteLetter) > 127;
    }

    protected void loadFilterLetterAndOctave() {
        if (this.selectedSwitchboardStack != null) {
            this.filterNoteLetter = ItemMidiSwitchboard.getFilterNote(this.selectedSwitchboardStack).intValue();
            this.filterNoteOctave = ItemMidiSwitchboard.getFilterOct(this.selectedSwitchboardStack).intValue();
            this.filterNoteString = ItemMidiSwitchboard.getFilteredNotesAsString(this.selectedSwitchboardStack);
        } else {
            this.filterNoteOctave = 127;
            this.filterNoteLetter = 127;
            this.filterNoteString = "";
        }
    }

    protected Boolean channelWidgetEnabled() {
        return false;
    }

    protected Boolean noteFilterWidgetEnabled() {
        return false;
    }

    protected Boolean instrumentFilterWidgetEnabled() {
        return false;
    }

    protected Boolean linkedTransmitterWidgetEnabled() {
        return false;
    }

    protected Boolean broadcastModeWidgetEnabled() {
        return false;
    }

    protected Boolean broadcastNoteWidgetEnabled() {
        return false;
    }

    protected Boolean instrumentVolumeWidgetEnabled() {
        return false;
    }

    protected abstract Vector2f titleBoxPos();

    protected abstract Vector2f titleBoxBlit();

    protected abstract Vector2f titleBoxSize();

    protected Vector2f switchboardSlotPos() {
        return new Vector2f(9.0f, 187.0f);
    }
}

