/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client;

import io.github.tofodroid.mods.mimi.client.midi.MidiInputManager;
import io.github.tofodroid.mods.mimi.client.midi.MidiSynthManager;
import io.github.tofodroid.mods.mimi.client.renderer.EntityMechanicalMaestroRenderer;
import io.github.tofodroid.mods.mimi.client.renderer.EntitySeatRenderer;
import io.github.tofodroid.mods.mimi.common.Proxy;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.item.IDyeableInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.keybind.ModBindings;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ClientProxy
implements Proxy {
    private MidiSynthManager MIDI_SYNTH;
    private MidiInputManager MIDI_INPUT;

    @Override
    public void init(FMLCommonSetupEvent event) {
        this.MIDI_SYNTH = new MidiSynthManager();
        MinecraftForge.EVENT_BUS.register((Object)this.MIDI_SYNTH);
        this.MIDI_INPUT = new MidiInputManager();
        MinecraftForge.EVENT_BUS.register((Object)this.MIDI_INPUT);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SEAT, EntitySeatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NOTERESPONSIVETILE, EntityMechanicalMaestroRenderer::new);
        ModBindings.register();
        MinecraftForge.EVENT_BUS.register((Object)new ModBindings());
    }

    @Override
    public MidiSynthManager getMidiSynth() {
        return this.MIDI_SYNTH;
    }

    @Override
    public MidiInputManager getMidiInput() {
        return this.MIDI_INPUT;
    }

    protected static void registerItemColors(ColorHandlerEvent.Item event, List<? extends Item> items) {
        event.getItemColors().func_199877_a((stack, color) -> color > 0 ? -1 : ((IDyeableInstrumentItem)stack.func_77973_b()).func_200886_f(stack), (IItemProvider[])items.toArray(new Item[items.size()]));
    }

    protected static void registerBlockColors(ColorHandlerEvent.Block event, List<? extends Block> blocks) {
        event.getBlockColors().func_186722_a((state, reader, pos, color) -> reader != null && pos != null && reader.func_175625_s(pos) != null && reader.func_175625_s(pos) instanceof TileInstrument ? ((TileInstrument)reader.func_175625_s(pos)).getColor() : -1, blocks.toArray(new Block[blocks.size()]));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientRegistrationHandler {
        @SubscribeEvent
        public static void register(ColorHandlerEvent.Item event) {
            ClientProxy.registerItemColors(event, ModItems.INSTRUMENT_ITEMS.stream().filter(i -> i.isDyeable()).collect(Collectors.toList()));
            ClientProxy.registerItemColors(event, ModItems.BLOCK_INSTRUMENT_ITEMS.stream().filter(i -> i.isDyeable()).collect(Collectors.toList()));
        }

        @SubscribeEvent
        public static void register(ColorHandlerEvent.Block event) {
            ClientProxy.registerBlockColors(event, ModBlocks.INSTRUMENTS.stream().filter(i -> i.isDyeable()).collect(Collectors.toList()));
        }
    }
}

