/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt.custom;

import de.bluecolored.shadow.querz.nbt.ArrayTag;
import de.bluecolored.shadow.querz.nbt.TagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ShortArrayTag
extends ArrayTag<short[]>
implements Comparable<ShortArrayTag> {
    public static final short[] ZERO_VALUE = new short[0];

    public static void register() {
        TagFactory.registerCustomTag(100, ShortArrayTag::new, ShortArrayTag.class);
    }

    public ShortArrayTag() {
        super(ZERO_VALUE);
    }

    public ShortArrayTag(short[] value) {
        super(value);
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeInt(this.length());
        for (short i : (short[])this.getValue()) {
            dos.writeShort(i);
        }
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        int length = dis.readInt();
        this.setValue(new short[length]);
        for (int i = 0; i < length; ++i) {
            ((short[])this.getValue())[i] = dis.readShort();
        }
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.arrayToString("S", "s");
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && (this.getValue() == ((ShortArrayTag)other).getValue() || ((short[])this.getValue()).length == ((ShortArrayTag)other).length() && Arrays.equals((short[])this.getValue(), (short[])((ShortArrayTag)other).getValue()));
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((short[])this.getValue());
    }

    @Override
    public int compareTo(ShortArrayTag other) {
        return Integer.compare(this.length(), other.length());
    }

    @Override
    public ShortArrayTag clone() {
        return new ShortArrayTag(Arrays.copyOf((short[])this.getValue(), this.length()));
    }
}

