/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt.custom;

import de.bluecolored.shadow.querz.nbt.Tag;
import de.bluecolored.shadow.querz.nbt.TagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class ObjectTag<T extends Serializable>
extends Tag<T>
implements Comparable<ObjectTag<T>> {
    public static void register() {
        TagFactory.registerCustomTag(90, ObjectTag::new, ObjectTag.class);
    }

    public ObjectTag() {
        super(null);
    }

    public ObjectTag(T value) {
        super(value);
    }

    @Override
    protected T checkValue(T value) {
        return value;
    }

    @Override
    public T getValue() {
        return (T)((Serializable)super.getValue());
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
    }

    public <L extends Serializable> ObjectTag<L> asTypedObjectTag(Class<L> type) {
        this.checkTypeClass(type);
        return this;
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        new ObjectOutputStream(dos).writeObject(this.getValue());
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        try {
            this.setValue((T)((Serializable)new ObjectInputStream(dis).readObject()));
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            throw new IOException(e.getCause());
        }
    }

    @Override
    public String valueToString(int maxDepth) {
        return this.getValue() == null ? "null" : ObjectTag.escapeString(this.getValue().toString(), false);
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.getValue() == null ? "null" : ObjectTag.escapeString(this.getValue().toString(), true);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(this.getValue(), ((ObjectTag)other).getValue());
    }

    @Override
    public int hashCode() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.getValue().hashCode();
    }

    @Override
    public int compareTo(ObjectTag<T> o) {
        if (o.getValue() instanceof Comparable && this.getValue() instanceof Comparable) {
            return ((Comparable)this.getValue()).compareTo(o.getValue());
        }
        if (o.getValue() == this.getValue()) {
            return 0;
        }
        if (this.getValue() == null) {
            return 1;
        }
        if (o.getValue() == null) {
            return -1;
        }
        return 0;
    }

    @Override
    public ObjectTag<T> clone() {
        if (this.getValue() == null) {
            return new ObjectTag<T>();
        }
        try {
            return new ObjectTag<Serializable>((Serializable)this.getValue().getClass().getMethod("clone", new Class[0]).invoke(this.getValue(), new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return new ObjectTag<Object>(this.getValue());
        }
    }

    private void checkTypeClass(Class<?> clazz) {
        if (this.getValue() != null && !clazz.isAssignableFrom(this.getValue().getClass())) {
            throw new ClassCastException(String.format("cannot cast ObjectTag<%s> to ObjectTag<%s>", this.getValue().getClass().getSimpleName(), clazz.getSimpleName()));
        }
    }
}

