/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.NumberTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FloatTag
extends NumberTag<Float>
implements Comparable<FloatTag> {
    public static final float ZERO_VALUE = 0.0f;

    public FloatTag() {
        super(Float.valueOf(0.0f));
    }

    public FloatTag(float value) {
        super(Float.valueOf(value));
    }

    @Override
    public void setValue(float value) {
        super.setValue(Float.valueOf(value));
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeFloat(((Float)this.getValue()).floatValue());
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        this.setValue(dis.readFloat());
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.getValue() + "f";
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((Float)this.getValue()).equals(((FloatTag)other).getValue());
    }

    @Override
    public int compareTo(FloatTag other) {
        return ((Float)this.getValue()).compareTo((Float)other.getValue());
    }

    @Override
    public FloatTag clone() {
        return new FloatTag(((Float)this.getValue()).floatValue());
    }
}

