/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.ArrayTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ByteArrayTag
extends ArrayTag<byte[]>
implements Comparable<ByteArrayTag> {
    public static final byte[] ZERO_VALUE = new byte[0];

    public ByteArrayTag() {
        super(ZERO_VALUE);
    }

    public ByteArrayTag(byte[] value) {
        super(value);
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeInt(this.length());
        dos.write((byte[])this.getValue());
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        int length = dis.readInt();
        this.setValue(new byte[length]);
        dis.readFully((byte[])this.getValue());
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.arrayToString("B", "b");
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Arrays.equals((byte[])this.getValue(), (byte[])((ByteArrayTag)other).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((byte[])this.getValue());
    }

    @Override
    public int compareTo(ByteArrayTag other) {
        return Integer.compare(this.length(), other.length());
    }

    @Override
    public ByteArrayTag clone() {
        return new ByteArrayTag(Arrays.copyOf((byte[])this.getValue(), this.length()));
    }
}

