/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.plugin.serverinterface.Gamemode;
import de.bluecolored.bluemap.common.plugin.serverinterface.Player;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.forge.ForgeMod;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameType;

public class ForgePlayer
implements Player {
    private static final UUID UNKNOWN_WORLD_UUID = UUID.randomUUID();
    private static final Map<GameType, Gamemode> GAMEMODE_MAP = new EnumMap<GameType, Gamemode>(GameType.class);
    private UUID uuid;
    private Text name;
    private UUID world;
    private Vector3d position;
    private boolean online;
    private boolean sneaking;
    private boolean invisible;
    private Gamemode gamemode;
    private ForgeMod mod;

    public ForgePlayer(ForgeMod mod, UUID playerUuid) {
        this.uuid = playerUuid;
        this.mod = mod;
        this.update();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Text getName() {
        return this.name;
    }

    @Override
    public UUID getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void update() {
        EffectInstance invis;
        MinecraftServer server = this.mod.getServer();
        if (server == null) {
            this.online = false;
            return;
        }
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(this.uuid);
        if (player == null) {
            this.online = false;
            return;
        }
        this.gamemode = GAMEMODE_MAP.get(player.field_71134_c.func_73081_b());
        if (this.gamemode == null) {
            this.gamemode = Gamemode.SURVIVAL;
        }
        this.invisible = (invis = player.func_70660_b(Effects.field_76441_p)) != null && invis.func_76459_b() > 0;
        this.name = Text.of(player.func_200200_C_().getString());
        this.online = true;
        net.minecraft.util.math.vector.Vector3d pos = player.func_213303_ch();
        this.position = new Vector3d(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        this.sneaking = player.func_225608_bj_();
        try {
            this.world = this.mod.getUUIDForWorld(player.func_71121_q());
        }
        catch (IOException e) {
            this.world = UNKNOWN_WORLD_UUID;
        }
    }

    static {
        GAMEMODE_MAP.put(GameType.ADVENTURE, Gamemode.ADVENTURE);
        GAMEMODE_MAP.put(GameType.SURVIVAL, Gamemode.SURVIVAL);
        GAMEMODE_MAP.put(GameType.CREATIVE, Gamemode.CREATIVE);
        GAMEMODE_MAP.put(GameType.SPECTATOR, Gamemode.SPECTATOR);
        GAMEMODE_MAP.put(GameType.NOT_SET, Gamemode.SURVIVAL);
    }
}

