/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.commands.Commands;
import de.bluecolored.bluemap.common.plugin.serverinterface.Player;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerInterface;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.forge.ForgeCommandSource;
import de.bluecolored.bluemap.forge.ForgeEventForwarder;
import de.bluecolored.bluemap.forge.ForgePlayer;
import de.bluecolored.bluemap.forge.Log4jLogger;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

@Mod(value="bluemap")
public class ForgeMod
implements ServerInterface {
    private Plugin pluginInstance = null;
    private MinecraftServer serverInstance = null;
    private Map<File, UUID> worldUUIDs;
    private ForgeEventForwarder eventForwarder;
    private LoadingCache<ServerWorld, UUID> worldUuidCache;
    private int playerUpdateIndex = 0;
    private Map<UUID, Player> onlinePlayerMap;
    private List<ForgePlayer> onlinePlayerList;

    public ForgeMod() {
        Logger.global = new Log4jLogger(LogManager.getLogger((String)"BlueMap"));
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.pluginInstance = new Plugin(new MinecraftVersion(1, 16, 2), "forge-1.16.2", this);
        this.worldUUIDs = new ConcurrentHashMap<File, UUID>();
        this.eventForwarder = new ForgeEventForwarder();
        this.worldUuidCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().maximumSize(1000L).build(this::loadUUIDForWorld);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        this.serverInstance = event.getServer();
        new Commands<CommandSource>(this.pluginInstance, event.getServer().func_195571_aL().func_197054_a(), forgeSource -> new ForgeCommandSource(this, this.pluginInstance, (CommandSource)forgeSource));
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        this.serverInstance.func_213211_a(false, true, true);
        new Thread(() -> {
            Logger.global.logInfo("Loading...");
            try {
                this.pluginInstance.load();
                if (this.pluginInstance.isLoaded()) {
                    Logger.global.logInfo("Loaded!");
                }
            }
            catch (ParseResourceException | IOException e) {
                Logger.global.logError("Failed to load bluemap!", e);
                this.pluginInstance.unload();
            }
        }).start();
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.pluginInstance.unload();
        Logger.global.logInfo("BlueMap unloaded!");
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        this.updateSomePlayers();
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        this.eventForwarder.addEventListener(listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.eventForwarder.removeAllListeners();
    }

    @Override
    public UUID getUUIDForWorld(File worldFolder) throws IOException {
        UUID uuid = this.worldUUIDs.get(worldFolder = worldFolder.getCanonicalFile());
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.worldUUIDs.put(worldFolder, uuid);
        }
        return uuid;
    }

    public UUID getUUIDForWorld(ServerWorld world) throws IOException {
        try {
            return this.worldUuidCache.get(world);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private UUID loadUUIDForWorld(ServerWorld world) throws IOException {
        File key = this.getFolderForWorld(world);
        UUID uuid = this.worldUUIDs.get(key);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.worldUUIDs.put(key, uuid);
        }
        return uuid;
    }

    private File getFolderForWorld(ServerWorld world) throws IOException {
        MinecraftServer server = world.func_73046_m();
        File worldFolder = world.func_73046_m().func_71238_n().toPath().resolve(server.func_240776_a_(FolderName.field_237253_i_)).toFile();
        File dimensionFolder = DimensionType.func_236031_a_((RegistryKey)world.func_234923_W_(), (File)worldFolder);
        return dimensionFolder.getCanonicalFile();
    }

    @Override
    public boolean persistWorldChanges(UUID worldUUID) throws IOException, IllegalArgumentException {
        CompletableFuture taskResult = new CompletableFuture();
        this.serverInstance.execute(() -> {
            try {
                for (ServerWorld world : this.serverInstance.func_212370_w()) {
                    if (!this.getUUIDForWorld(world).equals(worldUUID)) continue;
                    world.func_217445_a(null, true, false);
                }
                taskResult.complete(true);
            }
            catch (Exception e) {
                taskResult.completeExceptionally(e);
            }
        });
        try {
            return (Boolean)taskResult.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IOException(t);
        }
    }

    @Override
    public File getConfigFolder() {
        return new File("config/bluemap");
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        PlayerEntity playerInstance = evt.getPlayer();
        if (!(playerInstance instanceof ServerPlayerEntity)) {
            return;
        }
        ForgePlayer player = new ForgePlayer(this, playerInstance.func_110124_au());
        this.onlinePlayerMap.put(player.getUuid(), player);
        this.onlinePlayerList.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        PlayerEntity player = evt.getPlayer();
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        UUID playerUUID = player.func_110124_au();
        this.onlinePlayerMap.remove(playerUUID);
        List<ForgePlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    public MinecraftServer getServer() {
        return this.serverInstance;
    }

    public Plugin getPlugin() {
        return this.pluginInstance;
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    @Override
    public Optional<Player> getPlayer(UUID uuid) {
        return Optional.ofNullable(this.onlinePlayerMap.get(uuid));
    }

    private void updateSomePlayers() {
        int onlinePlayerCount = this.onlinePlayerList.size();
        if (onlinePlayerCount == 0) {
            return;
        }
        int playersToBeUpdated = onlinePlayerCount / 20;
        if (playersToBeUpdated == 0) {
            playersToBeUpdated = 1;
        }
        for (int i = 0; i < playersToBeUpdated; ++i) {
            ++this.playerUpdateIndex;
            if (this.playerUpdateIndex >= 20 && this.playerUpdateIndex >= onlinePlayerCount) {
                this.playerUpdateIndex = 0;
            }
            if (this.playerUpdateIndex >= onlinePlayerCount) continue;
            this.onlinePlayerList.get(this.playerUpdateIndex).update();
        }
    }
}

