/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import com.flowpowered.math.vector.Vector2i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class Grid {
    public static final Grid UNIT = new Grid(Vector2i.ONE);
    private final Vector2i gridSize;
    private final Vector2i offset;

    public Grid(int gridSize) {
        this(gridSize, 0);
    }

    public Grid(int gridSize, int offset) {
        this(new Vector2i(gridSize, gridSize), new Vector2i(offset, offset));
    }

    public Grid(Vector2i gridSize) {
        this(gridSize, Vector2i.ZERO);
    }

    public Grid(Vector2i gridSize, Vector2i offset) {
        Objects.requireNonNull(gridSize);
        Objects.requireNonNull(offset);
        this.gridSize = gridSize = gridSize.max(1, 1);
        this.offset = offset;
    }

    public Vector2i getGridSize() {
        return this.gridSize;
    }

    public Vector2i getOffset() {
        return this.offset;
    }

    public Vector2i getCell(Vector2i pos) {
        return new Vector2i(Math.floorDiv(pos.getX() - this.offset.getX(), this.gridSize.getX()), Math.floorDiv(pos.getY() - this.offset.getY(), this.gridSize.getY()));
    }

    public Vector2i getCellMin(Vector2i cell) {
        return new Vector2i(cell.getX() * this.gridSize.getX() + this.offset.getX(), cell.getY() * this.gridSize.getY() + this.offset.getY());
    }

    public Vector2i getCellMax(Vector2i cell) {
        return new Vector2i((cell.getX() + 1) * this.gridSize.getX() + this.offset.getX() - 1, (cell.getY() + 1) * this.gridSize.getY() + this.offset.getY() - 1);
    }

    public Vector2i getCellMin(Vector2i cell, Grid targetGrid) {
        return targetGrid.getCell(this.getCellMin(cell));
    }

    public Vector2i getCellMax(Vector2i cell, Grid targetGrid) {
        return targetGrid.getCell(this.getCellMax(cell));
    }

    public Collection<Vector2i> getIntersecting(Vector2i cell, Grid targetGrid) {
        Vector2i max;
        Vector2i min2 = this.getCellMin(cell, targetGrid);
        if (min2.equals(max = this.getCellMin(cell, targetGrid))) {
            return Collections.singleton(min2);
        }
        ArrayList<Vector2i> intersects = new ArrayList<Vector2i>();
        for (int x = min2.getX(); x <= max.getX(); ++x) {
            for (int y = min2.getY(); y <= max.getY(); ++y) {
                intersects.add(new Vector2i(x, y));
            }
        }
        return intersects;
    }

    public Grid multiply(Grid other) {
        return new Grid(this.gridSize.mul(other.gridSize), this.offset.mul(other.gridSize).add(other.offset));
    }

    public Grid divide(Grid other) {
        return new Grid(this.gridSize.div(other.gridSize), this.offset.sub(other.offset).div(other.gridSize));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grid grid = (Grid)o;
        return this.gridSize.equals(grid.gridSize) && this.offset.equals(grid.offset);
    }

    public int hashCode() {
        return Objects.hash(this.gridSize, this.offset);
    }

    public String toString() {
        return "Grid{gridSize=" + this.gridSize + ", offset=" + this.offset + '}';
    }
}

