/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.Block;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;
import java.util.Objects;

public class ExtendedBlock<T extends ExtendedBlock<T>>
extends Block<T> {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;
    private BlockProperties properties;
    private Biome biome;
    private Boolean insideRenderBounds;

    public ExtendedBlock(ResourcePack resourcePack, RenderSettings renderSettings, World world, int x, int y, int z) {
        super(world, x, y, z);
        this.resourcePack = Objects.requireNonNull(resourcePack);
        this.renderSettings = renderSettings;
    }

    @Override
    protected void reset() {
        super.reset();
        this.properties = null;
        this.biome = null;
        this.insideRenderBounds = null;
    }

    @Override
    public BlockState getBlockState() {
        if (!this.isInsideRenderBounds() && this.renderSettings.isRenderEdges()) {
            return BlockState.AIR;
        }
        return super.getBlockState();
    }

    @Override
    public LightData getLightData() {
        LightData ld = super.getLightData();
        if (!this.isInsideRenderBounds() && this.renderSettings.isRenderEdges()) {
            ld.set(this.getWorld().getSkyLight(), ld.getBlockLight());
        }
        return ld;
    }

    public BlockProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.resourcePack.getBlockProperties(this.getBlockState());
        }
        return this.properties;
    }

    public Biome getBiome() {
        if (this.biome == null) {
            this.biome = this.resourcePack.getBiome(this.getBiomeId());
        }
        return this.biome;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public boolean isInsideRenderBounds() {
        if (this.insideRenderBounds == null) {
            this.insideRenderBounds = this.renderSettings.isInsideRenderBoundaries(this.getX(), this.getY(), this.getZ());
        }
        return this.insideRenderBounds;
    }

    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }
}

