/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockState {
    private static final Pattern BLOCKSTATE_SERIALIZATION_PATTERN = Pattern.compile("^(.+?)(?:\\[(.*)])?$");
    public static final BlockState AIR = new BlockState("minecraft:air");
    public static final BlockState MISSING = new BlockState("bluemap:missing");
    private boolean hashed = false;
    private int hash = 0;
    private final String namespace;
    private final String id;
    private final String fullId;
    private final Map<String, String> properties;
    private final boolean isAir;
    private final boolean isWater;
    private final boolean isWaterlogged;

    public BlockState(String id) {
        this(id, Collections.emptyMap());
    }

    public BlockState(String id, Map<String, String> properties) {
        this.properties = properties;
        String namespace = "minecraft";
        int namespaceSeperator = id.indexOf(58);
        if (namespaceSeperator > 0) {
            namespace = id.substring(0, namespaceSeperator);
            id = id.substring(namespaceSeperator + 1);
        }
        this.id = id;
        this.namespace = namespace;
        this.fullId = namespace + ":" + id;
        this.isAir = "minecraft:air".equals(this.fullId) || "minecraft:cave_air".equals(this.fullId) || "minecraft:void_air".equals(this.fullId);
        this.isWater = "minecraft:water".equals(this.fullId);
        this.isWaterlogged = "true".equals(properties.get("waterlogged"));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        return this.fullId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isWater() {
        return this.isWater;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockState)) {
            return false;
        }
        BlockState b = (BlockState)obj;
        if (!Objects.equals(this.getFullId(), b.getFullId())) {
            return false;
        }
        return Objects.equals(this.getProperties(), b.getProperties());
    }

    public int hashCode() {
        if (!this.hashed) {
            this.hash = Objects.hash(this.getFullId(), this.getProperties());
            this.hashed = true;
        }
        return this.hash;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            sj.add(e.getKey() + "=" + e.getValue());
        }
        return this.getFullId() + "[" + sj.toString() + "]";
    }

    public static BlockState fromString(String serializedBlockState) throws IllegalArgumentException {
        try {
            Matcher m3 = BLOCKSTATE_SERIALIZATION_PATTERN.matcher(serializedBlockState);
            if (!m3.find()) {
                throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
            }
            HashMap<String, String> pt = new HashMap<String, String>();
            String g2 = m3.group(2);
            if (g2 != null && !g2.isEmpty()) {
                String[] propertyStrings;
                for (String s2 : propertyStrings = g2.trim().split(",")) {
                    String[] kv = s2.split("=", 2);
                    pt.put(kv[0], kv[1]);
                }
            }
            String blockId = m3.group(1).trim();
            return new BlockState(blockId, pt);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
        }
    }
}

