/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.ExtendedBlock;
import de.bluecolored.bluemap.core.world.World;

public class BlockNeighborhood<T extends BlockNeighborhood<T>>
extends ExtendedBlock<T> {
    private static final int DIAMETER = 8;
    private static final int DIAMETER_MASK = 7;
    private static final int DIAMETER_SQUARED = 64;
    private final ExtendedBlock<?>[] neighborhood;
    private int thisIndex;

    public BlockNeighborhood(ExtendedBlock<?> center) {
        super(center.getResourcePack(), center.getRenderSettings(), null, 0, 0, 0);
        this.copy(center);
        this.neighborhood = new ExtendedBlock[512];
        this.init();
    }

    public BlockNeighborhood(ResourcePack resourcePack, RenderSettings renderSettings, World world, int x, int y, int z) {
        super(resourcePack, renderSettings, world, x, y, z);
        this.neighborhood = new ExtendedBlock[512];
        this.init();
    }

    @Override
    protected void reset() {
        super.reset();
        this.thisIndex = -1;
    }

    private void init() {
        this.thisIndex = -1;
        for (int i = 0; i < this.neighborhood.length; ++i) {
            this.neighborhood[i] = new ExtendedBlock(this.getResourcePack(), this.getRenderSettings(), null, 0, 0, 0);
        }
    }

    public ExtendedBlock<?> getNeighborBlock(int dx, int dy, int dz) {
        int i = this.neighborIndex(dx, dy, dz);
        if (i == this.thisIndex()) {
            return this;
        }
        return (ExtendedBlock)this.neighborhood[i].set(this.getWorld(), this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    private int thisIndex() {
        if (this.thisIndex == -1) {
            this.thisIndex = this.neighborIndex(0, 0, 0);
        }
        return this.thisIndex;
    }

    private int neighborIndex(int dx, int dy, int dz) {
        return (this.getX() + dx & 7) * 64 + (this.getY() + dy & 7) * 8 + (this.getZ() + dz & 7);
    }
}

