/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.util.ConfigUtils;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.shadow.configurate.ConfigurationNode;

public class Biome {
    public static final Biome DEFAULT = new Biome();
    private String id = "ocean";
    private int numeralId = 0;
    private float humidity = 0.5f;
    private float temp = 0.5f;
    private Color waterColor = new Color().set(4159204).premultiplied();
    private Color overlayFoliageColor = new Color().premultiplied();
    private Color overlayGrassColor = new Color().premultiplied();

    private Biome() {
    }

    public Biome(String id, int numeralId, float humidity, float temp, Color waterColor) {
        this.id = id;
        this.numeralId = numeralId;
        this.humidity = humidity;
        this.temp = temp;
        this.waterColor = waterColor;
    }

    public Biome(String id, int numeralId, float humidity, float temp, Color waterColor, Color overlayFoliageColor, Color overlayGrassColor) {
        this(id, numeralId, humidity, temp, waterColor);
        this.overlayFoliageColor = overlayFoliageColor;
        this.overlayGrassColor = overlayGrassColor;
    }

    public String getId() {
        return this.id;
    }

    public int getNumeralId() {
        return this.numeralId;
    }

    public float getHumidity() {
        return this.humidity;
    }

    public float getTemp() {
        return this.temp;
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public Color getOverlayFoliageColor() {
        return this.overlayFoliageColor;
    }

    public Color getOverlayGrassColor() {
        return this.overlayGrassColor;
    }

    public static Biome create(String id, ConfigurationNode node) {
        Biome biome = new Biome();
        biome.id = id;
        biome.numeralId = node.node("id").getInt(biome.numeralId);
        biome.humidity = node.node("humidity").getFloat(biome.humidity);
        biome.temp = node.node("temp").getFloat(biome.temp);
        try {
            biome.waterColor = new Color().set(ConfigUtils.readColorInt(node.node("watercolor"))).premultiplied();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            biome.overlayFoliageColor = new Color().set(ConfigUtils.readColorInt(node.node("foliagecolor"))).premultiplied();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            biome.overlayGrassColor = new Color().set(ConfigUtils.readColorInt(node.node("grasscolor"))).premultiplied();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return biome;
    }

    public String toString() {
        return "Biome{id='" + this.id + '\'' + ", numeralId=" + this.numeralId + ", humidity=" + this.humidity + ", temp=" + this.temp + ", waterColor=" + this.waterColor + ", overlayFoliageColor=" + this.overlayFoliageColor + ", overlayGrassColor=" + this.overlayGrassColor + '}';
    }
}

