/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.webserver;

import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.webserver.HttpConnection;
import de.bluecolored.bluemap.core.webserver.HttpRequestHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@DebugDump
public class WebServer
extends Thread {
    private final int port;
    private final int maxConnections;
    private final InetAddress bindAddress;
    private final boolean verbose;
    private final HttpRequestHandler handler;
    private final Semaphore processingSemaphore;
    private ThreadPoolExecutor connectionThreads;
    private ServerSocket server;

    public WebServer(InetAddress bindAddress, int port, int maxConnections, HttpRequestHandler handler) {
        this(bindAddress, port, maxConnections, handler, false);
    }

    public WebServer(InetAddress bindAddress, int port, int maxConnections, HttpRequestHandler handler, boolean verbose) {
        this.port = port;
        this.maxConnections = maxConnections;
        this.bindAddress = bindAddress;
        this.verbose = verbose;
        this.handler = handler;
        this.processingSemaphore = new Semaphore(24);
        this.connectionThreads = null;
    }

    @Override
    public synchronized void start() {
        this.close();
        this.connectionThreads = new ThreadPoolExecutor(Math.min(this.maxConnections, 8), this.maxConnections, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            this.server = new ServerSocket(this.port, this.maxConnections, this.bindAddress);
            this.server.setSoTimeout(0);
        }
        catch (IOException e) {
            Logger.global.logError("Error while starting the WebServer!", e);
            return;
        }
        super.start();
    }

    @Override
    public void run() {
        if (this.server == null) {
            return;
        }
        Logger.global.logInfo("WebServer started.");
        while (!this.server.isClosed() && this.server.isBound()) {
            try {
                Socket connection = this.server.accept();
                try {
                    this.connectionThreads.execute(new HttpConnection(this.server, connection, this.handler, this.processingSemaphore, 10, TimeUnit.SECONDS, this.verbose));
                }
                catch (RejectedExecutionException e) {
                    connection.close();
                    Logger.global.logWarning("Dropped an incoming HttpConnection! (Too many connections?)");
                }
            }
            catch (SocketException connection) {
            }
            catch (IOException e) {
                Logger.global.logError("Error while creating a new HttpConnection!", e);
            }
        }
        Logger.global.logInfo("WebServer closed.");
    }

    public synchronized void close() {
        if (this.connectionThreads != null) {
            this.connectionThreads.shutdown();
        }
        try {
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
        }
        catch (IOException e) {
            Logger.global.logError("Error while closing WebServer!", e);
        }
    }
}

