/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.webserver;

import de.bluecolored.bluemap.core.webserver.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HttpResponse
implements Closeable {
    private String version = "HTTP/1.1";
    private HttpStatusCode statusCode;
    private Map<String, Set<String>> header;
    private InputStream data;

    public HttpResponse(HttpStatusCode statusCode) {
        this.statusCode = statusCode;
        this.header = new HashMap<String, Set<String>>();
        this.addHeader("Connection", "keep-alive");
    }

    public void addHeader(String key, String value) {
        Set valueSet = this.header.computeIfAbsent(key, k -> new HashSet());
        valueSet.add(value);
    }

    public void removeHeader(String key, String value) {
        Set valueSet = this.header.computeIfAbsent(key, k -> new HashSet());
        valueSet.remove(value);
    }

    public void setData(InputStream dataStream) {
        this.data = dataStream;
    }

    public void setData(String data) {
        this.setData(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        if (this.data != null) {
            this.addHeader("Transfer-Encoding", "chunked");
        } else {
            this.addHeader("Content-Length", "0");
        }
        this.writeLine(writer, this.version + " " + this.statusCode.getCode() + " " + this.statusCode.getMessage());
        for (Map.Entry<String, Set<String>> e : this.header.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            this.writeLine(writer, e.getKey() + ": " + StringUtils.join((Iterable)e.getValue(), (String)", "));
        }
        this.writeLine(writer, "");
        writer.flush();
        if (this.data != null) {
            this.chunkedPipe(this.data, out);
            out.flush();
            this.data.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    private void writeLine(OutputStreamWriter writer, String line) throws IOException {
        writer.write(line + "\r\n");
    }

    private void chunkedPipe(InputStream input, OutputStream output) throws IOException {
        int byteCount;
        byte[] buffer = new byte[1024];
        while ((byteCount = input.read(buffer)) != -1) {
            output.write((Integer.toHexString(byteCount) + "\r\n").getBytes());
            output.write(buffer, 0, byteCount);
            output.write("\r\n".getBytes());
        }
        output.write("0\r\n\r\n".getBytes());
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Set<String>> getHeader() {
        return this.header;
    }

    public Set<String> getHeader(String key) {
        Set<String> headerValues = this.header.get(key);
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }
}

