/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.webserver;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.webserver.HttpRequest;
import de.bluecolored.bluemap.core.webserver.HttpRequestHandler;
import de.bluecolored.bluemap.core.webserver.HttpResponse;
import de.bluecolored.bluemap.core.webserver.HttpStatusCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class HttpConnection
implements Runnable {
    private final HttpRequestHandler handler;
    private final ServerSocket server;
    private final Socket connection;
    private final InputStream in;
    private final OutputStream out;
    private final Semaphore processingSemaphore;
    private final boolean verbose;

    public HttpConnection(ServerSocket server, Socket connection, HttpRequestHandler handler, Semaphore processingSemaphore, int timeout, TimeUnit timeoutUnit, boolean verbose) throws IOException {
        this.server = server;
        this.connection = connection;
        this.handler = handler;
        this.verbose = verbose;
        this.processingSemaphore = processingSemaphore;
        if (this.isClosed()) {
            throw new IOException("Socket already closed!");
        }
        connection.setSoTimeout((int)timeoutUnit.toMillis(timeout));
        this.in = new BufferedInputStream(this.connection.getInputStream());
        this.out = new BufferedOutputStream(this.connection.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isClosed() && !this.server.isClosed()) {
            try {
                HttpRequest request = this.acceptRequest();
                boolean hasPermit = false;
                try {
                    hasPermit = this.processingSemaphore.tryAcquire(1L, TimeUnit.SECONDS);
                    HttpResponse response = this.handler.handle(request);
                    this.sendResponse(response);
                    if (!this.verbose) continue;
                    this.log(request, response);
                }
                finally {
                    if (!hasPermit) continue;
                    this.processingSemaphore.release();
                }
            }
            catch (InvalidRequestException e) {
                try {
                    this.sendResponse(new HttpResponse(HttpStatusCode.BAD_REQUEST));
                }
                catch (IOException iOException) {}
                break;
            }
            catch (ConnectionClosedException | SocketException | SocketTimeoutException e) {
                break;
            }
            catch (IOException e) {
                Logger.global.logError("Unexpected error while processing a HttpRequest!", e);
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            Logger.global.logError("Error while closing HttpConnection!", e);
        }
    }

    private void log(HttpRequest request, HttpResponse response) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        Logger.global.logInfo(this.connection.getInetAddress().toString() + " [ " + dateFormat.format(date) + " ] \"" + request.getMethod() + " " + request.getPath() + " " + request.getVersion() + "\" " + response.getStatusCode().toString());
    }

    private void sendResponse(HttpResponse response) throws IOException {
        response.write(this.out);
        this.out.flush();
    }

    private HttpRequest acceptRequest() throws ConnectionClosedException, InvalidRequestException, IOException {
        return HttpRequest.read(this.in);
    }

    public boolean isClosed() {
        return !this.connection.isBound() || this.connection.isClosed() || !this.connection.isConnected() || this.connection.isOutputShutdown() || this.connection.isInputShutdown();
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public static class InvalidRequestException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ConnectionClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

