/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

public class Color {
    public float r;
    public float g;
    public float b;
    public float a;
    public boolean premultiplied;

    public Color set(float r, float g2, float b, float a, boolean premultiplied) {
        this.r = r;
        this.g = g2;
        this.b = b;
        this.a = a;
        this.premultiplied = premultiplied;
        return this;
    }

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        this.premultiplied = color.premultiplied;
        return this;
    }

    public Color set(int color) {
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
        this.a = (float)(color >> 24 & 0xFF) / 255.0f;
        this.premultiplied = false;
        if (this.a == 0.0f) {
            this.a = 1.0f;
        }
        return this;
    }

    public Color add(Color color) {
        if (color.a < 1.0f && !color.premultiplied) {
            throw new IllegalArgumentException("Can only add premultiplied colors with alpha!");
        }
        this.premultiplied();
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        this.a += color.a;
        return this;
    }

    public Color multiply(Color color) {
        if (color.premultiplied) {
            this.premultiplied();
        } else {
            this.straight();
        }
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        this.a *= color.a;
        return this;
    }

    public Color overlay(Color color) {
        if (color.a < 1.0f && !color.premultiplied) {
            throw new IllegalArgumentException("Can only overlay premultiplied colors with alpha!");
        }
        this.premultiplied();
        float p = 1.0f - color.a;
        this.a = p * this.a + color.a;
        this.r = p * this.r + color.r;
        this.g = p * this.g + color.g;
        this.b = p * this.b + color.b;
        return this;
    }

    public Color flatten() {
        if (this.a == 1.0f) {
            return this;
        }
        if (this.premultiplied) {
            this.r /= this.a;
            this.g /= this.a;
            this.b /= this.a;
        }
        this.a = 1.0f;
        return this;
    }

    public Color premultiplied() {
        if (!this.premultiplied) {
            this.r *= this.a;
            this.g *= this.a;
            this.b *= this.a;
            this.premultiplied = true;
        }
        return this;
    }

    public Color straight() {
        if (this.premultiplied) {
            float m3 = 1.0f / this.a;
            this.r *= m3;
            this.g *= m3;
            this.b *= m3;
            this.premultiplied = false;
        }
        return this;
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ", premultiplied=" + this.premultiplied + '}';
    }
}

