/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector4f;

@Deprecated
public class MathUtils {
    private MathUtils() {
    }

    public static Vector3d getSurfaceNormal(Vector3d p1, Vector3d p2, Vector3d p3) {
        Vector3d u = p2.sub(p1);
        Vector3d v = p3.sub(p1);
        double nX = u.getY() * v.getZ() - u.getZ() * v.getY();
        double nY = u.getZ() * v.getX() - u.getX() * v.getZ();
        double nZ = u.getX() * v.getY() - u.getY() * v.getX();
        return new Vector3d(nX, nY, nZ);
    }

    public static Vector3f getSurfaceNormal(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f u = p2.sub(p1);
        Vector3f v = p3.sub(p1);
        float nX = u.getY() * v.getZ() - u.getZ() * v.getY();
        float nY = u.getZ() * v.getX() - u.getX() * v.getZ();
        float nZ = u.getX() * v.getY() - u.getY() * v.getX();
        Vector3f n = new Vector3f(nX, nY, nZ);
        n = n.normalize();
        return n;
    }

    public static float hashToFloat(Vector3i pos, long seed) {
        return MathUtils.hashToFloat(pos.getX(), pos.getY(), pos.getZ(), seed);
    }

    public static float hashToFloat(int x, int y, int z, long seed) {
        long hash = (long)(x * 73428767 ^ y * 9122569 ^ z * 4382893) ^ seed * 457L;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }

    public static Vector4f blendColors(Vector4f top, Vector4f bottom) {
        if (top.getW() > 0.0f && bottom.getW() > 0.0f) {
            float a = 1.0f - (1.0f - top.getW()) * (1.0f - bottom.getW());
            float r = top.getX() * top.getW() / a + bottom.getX() * bottom.getW() * (1.0f - top.getW()) / a;
            float g2 = top.getY() * top.getW() / a + bottom.getY() * bottom.getW() * (1.0f - top.getW()) / a;
            float b = top.getZ() * top.getW() / a + bottom.getZ() * bottom.getW() * (1.0f - top.getW()) / a;
            return new Vector4f(r, g2, b, a);
        }
        if (bottom.getW() > 0.0f) {
            return bottom;
        }
        return top;
    }

    public static Vector4f overlayColors(Vector4f top, Vector4f bottom) {
        if (top.getW() > 0.0f && bottom.getW() > 0.0f) {
            float p = (1.0f - top.getW()) * bottom.getW();
            float a = p + top.getW();
            float r = (p * bottom.getX() + top.getW() * top.getX()) / a;
            float g2 = (p * bottom.getY() + top.getW() * top.getY()) / a;
            float b = (p * bottom.getZ() + top.getW() * top.getZ()) / a;
            return new Vector4f(r, g2, b, a);
        }
        if (bottom.getW() > 0.0f) {
            return bottom;
        }
        return top;
    }

    public static Vector3f color3FromInt(int color) {
        return new Vector3f(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF).div(255.0f);
    }

    public static Vector4f color4FromInt(int color) {
        return new Vector4f(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).div(255.0f);
    }
}

