/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import com.flowpowered.math.vector.Vector2i;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FileUtils {
    private FileUtils() {
    }

    public static void delete(File file) throws IOException {
        if (file.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
    }

    public static void mkDirs(File directory) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)directory);
    }

    public static void mkDirsParent(File file) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdirParent((File)file);
    }

    public static void createFile(File file) throws IOException {
        if (!file.exists()) {
            org.apache.commons.io.FileUtils.forceMkdirParent((File)file);
            if (!file.createNewFile()) {
                throw new IOException("Could not create file '" + file + "'!");
            }
        } else if (!file.isFile()) {
            throw new IOException("File '" + file + "' exists but is not a normal file!");
        }
    }

    public static File coordsToFile(Path root, Vector2i coords, String fileType) {
        String path = "x" + coords.getX() + "z" + coords.getY();
        char[] cs = path.toCharArray();
        ArrayList<String> folders = new ArrayList<String>();
        String folder = "";
        for (char c : cs) {
            folder = folder + c;
            if (c < '0' || c > '9') continue;
            folders.add(folder);
            folder = "";
        }
        String fileName = (String)folders.remove(folders.size() - 1);
        Path p = root;
        for (String s2 : folders) {
            p = p.resolve(s2);
        }
        return p.resolve(fileName + "." + fileType).toFile();
    }

    public static boolean matchPath(Path path, String ... pattern) {
        int p = 0;
        for (int i = 0; i < path.getNameCount(); ++i) {
            while (pattern[p].equals("*")) {
                if (pattern.length < ++p) continue;
                return true;
            }
            if (Pattern.matches(pattern[p], path.getName(i).toString())) {
                ++p;
                continue;
            }
            if (p > 0 && pattern[p - 1].equals("*")) continue;
            return false;
        }
        return true;
    }
}

