/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector4f;
import com.flowpowered.math.vector.Vector4i;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.NodePath;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.util.List;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static Vector2i readVector2i(ConfigurationNode vectorNode) {
        if (vectorNode.isList()) {
            List<? extends ConfigurationNode> list = vectorNode.childrenList();
            return new Vector2i(list.get(0).getInt(), list.get(1).getInt());
        }
        return new Vector2i(vectorNode.node("x").getInt(), vectorNode.node("y").getInt());
    }

    public static Vector3i readVector3i(ConfigurationNode vectorNode) {
        if (vectorNode.isList()) {
            List<? extends ConfigurationNode> list = vectorNode.childrenList();
            return new Vector3i(list.get(0).getInt(), list.get(1).getInt(), list.get(2).getInt());
        }
        return new Vector3i(vectorNode.node("x").getInt(), vectorNode.node("y").getInt(), vectorNode.node("z").getInt());
    }

    public static Vector3f readVector3f(ConfigurationNode vectorNode) {
        if (vectorNode.isList()) {
            List<? extends ConfigurationNode> list = vectorNode.childrenList();
            return new Vector3f(list.get(0).getFloat(), list.get(1).getFloat(), list.get(2).getFloat());
        }
        return new Vector3f(vectorNode.node("x").getFloat(), vectorNode.node("y").getFloat(), vectorNode.node("z").getFloat());
    }

    public static Vector4i readVector4i(ConfigurationNode vectorNode) {
        if (vectorNode.isList()) {
            List<? extends ConfigurationNode> list = vectorNode.childrenList();
            return new Vector4i(list.get(0).getInt(), list.get(1).getInt(), list.get(2).getInt(), list.get(3).getInt());
        }
        return new Vector4i(vectorNode.node("x").getInt(), vectorNode.node("y").getInt(), vectorNode.node("z").getInt(), vectorNode.node("w").getInt());
    }

    public static Vector4f readVector4f(ConfigurationNode vectorNode) {
        if (vectorNode.isList()) {
            List<? extends ConfigurationNode> list = vectorNode.childrenList();
            return new Vector4f(list.get(0).getFloat(), list.get(1).getFloat(), list.get(2).getFloat(), list.get(3).getFloat());
        }
        return new Vector4f(vectorNode.node("x").getFloat(), vectorNode.node("y").getFloat(), vectorNode.node("z").getFloat(), vectorNode.node("w").getFloat());
    }

    public static void writeVector4f(ConfigurationNode vectorNode, Vector4f v) throws SerializationException {
        vectorNode.appendListNode().set(Float.valueOf(v.getX()));
        vectorNode.appendListNode().set(Float.valueOf(v.getY()));
        vectorNode.appendListNode().set(Float.valueOf(v.getZ()));
        vectorNode.appendListNode().set(Float.valueOf(v.getW()));
    }

    public static int readColorInt(ConfigurationNode node) throws NumberFormatException {
        Object value = node.raw();
        if (value == null) {
            throw new NumberFormatException("No value!");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String val = value.toString();
        if (val.charAt(0) == '#') {
            if ((val = val.substring(1)).length() == 3) {
                val = "f" + val;
            }
            if (val.length() == 4) {
                val = "" + val.charAt(0) + val.charAt(0) + val.charAt(1) + val.charAt(1) + val.charAt(2) + val.charAt(2) + val.charAt(3) + val.charAt(3);
            }
            if (val.length() == 6) {
                val = "ff" + val;
            }
            return Integer.parseUnsignedInt(val, 16);
        }
        return Integer.parseInt(val);
    }

    public static String nodePathToString(ConfigurationNode node) {
        NodePath keys = node.path();
        CharSequence[] stringKeys = new String[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            stringKeys[i] = keys.get(i).toString();
        }
        return String.join((CharSequence)".", stringKeys);
    }
}

