/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.ThrowingRunnable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class AtomicFileHelper {
    public static OutputStream createFilepartOutputStream(File file) throws IOException {
        return AtomicFileHelper.createFilepartOutputStream(file.toPath());
    }

    public static OutputStream createFilepartOutputStream(Path file) throws IOException {
        Path partFile = AtomicFileHelper.getPartFile(file);
        Files.createDirectories(partFile.getParent(), new FileAttribute[0]);
        OutputStream os = Files.newOutputStream(partFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return new WrappedOutputStream(os, () -> {
            if (!Files.exists(partFile, new LinkOption[0])) {
                return;
            }
            Files.deleteIfExists(file);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try {
                Files.move(partFile, file, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (IOException ex) {
                try {
                    Files.move(partFile, file, new CopyOption[0]);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static Path getPartFile(Path file) {
        return file.normalize().getParent().resolve(file.getFileName() + ".filepart");
    }

    private static class WrappedOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final ThrowingRunnable<IOException> onClose;

        private WrappedOutputStream(OutputStream out, ThrowingRunnable<IOException> onClose) {
            this.out = out;
            this.onClose = onClose;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            this.onClose.run();
        }
    }
}

